"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiLoadingContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _skeleton = require("../skeleton");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @deprecated Use `EuiSkeletonText` instead
 */
var EuiLoadingContent = function EuiLoadingContent(props) {
  return (0, _react2.jsx)(_skeleton.EuiSkeletonText, props);
};
exports.EuiLoadingContent = EuiLoadingContent;
EuiLoadingContent.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * When true, shows the loading skeleton component.
     * When false, shows any `children` and announces to screen readers that your content has loaded.
     */
  isLoading: _propTypes.default.bool,
  /**
     * Label your loading sections to provide more helpful context to screen readers.
     * For example, pass "API keys" to have screen readers read "Loading API keys" and "Loaded API keys".
     */
  contentAriaLabel: _propTypes.default.string,
  /**
     * Any optional props to pass to the `aria-busy` wrapper around the skeleton content
     */
  ariaWrapperProps: _propTypes.default.any,
  /**
       * Number of lines to display (between 1 to 10)
       */
  lines: _propTypes.default.any,
  /**
       * EuiText size to render
       */
  size: _propTypes.default.any
};