"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiLoadingChartStyles = exports.euiLoadingChartBarStyles = exports._barIndex = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _templateObject;
function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
var _ref = process.env.NODE_ENV === "production" ? {
  name: "yovxj7-euiLoadingChart",
  styles: "overflow:hidden;display:inline-flex;label:euiLoadingChart;"
} : {
  name: "yovxj7-euiLoadingChart",
  styles: "overflow:hidden;display:inline-flex;label:euiLoadingChart;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiLoadingChartStyles = function euiLoadingChartStyles(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return {
    euiLoadingChart: _ref,
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.base), " gap:", euiTheme.size.xxs, ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.l), " gap:", euiTheme.size.xxs, ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', euiTheme.size.xl), " gap:", euiTheme.size.xs, ";;label:xl;")
  };
};
exports.euiLoadingChartStyles = euiLoadingChartStyles;
var euiLoadingChartBarStyles = function euiLoadingChartBarStyles(_ref3) {
  var euiTheme = _ref3.euiTheme;
  return {
    euiLoadingChart__bar: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('height', '100%'), " display:inline-block;;label:euiLoadingChart__bar;"),
    m: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', euiTheme.size.xxs), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.s), ";;label:m;"),
    l: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.m), ";;label:l;"),
    xl: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('margin-bottom', euiTheme.size.base), ";;label:xl;")
  };
};
exports.euiLoadingChartBarStyles = euiLoadingChartBarStyles;
var barAnimation = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  0% {\n    transform: translateY(0);\n  }\n\n  50% {\n    transform: translateY(66%);\n  }\n\n  100% {\n    transform: translateY(0);\n  }\n"])));
var _barIndex = function _barIndex(index, mono, _ref4) {
  var euiTheme = _ref4.euiTheme,
    colorMode = _ref4.colorMode;
  var backgroundColor = mono ? (0, _services.shadeOrTint)(euiTheme.colors.lightShade, index * 0.04, colorMode) : (0, _services.euiPaletteColorBlind)()[index];
  return /*#__PURE__*/(0, _react.css)("background-color:", backgroundColor, ";transform:translateY(", 22 * index, "%);", _global_styling.euiCanAnimate, "{animation:", barAnimation, " 1s ", ".".concat(index, "s"), " infinite;}");
};
exports._barIndex = _barIndex;