"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiListGroupStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _form = require("../form/form.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1urrzow-flush",
  styles: "padding:0;border:none;.euiListGroupItem{border-radius:0;};label:flush;"
} : {
  name: "1urrzow-flush",
  styles: "padding:0;border:none;.euiListGroupItem{border-radius:0;};label:flush;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "2tmo78-euiListGroup",
  styles: "display:flex;flex-direction:column;label:euiListGroup;"
} : {
  name: "2tmo78-euiListGroup",
  styles: "display:flex;flex-direction:column;label:euiListGroup;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiListGroupStyles = function euiListGroupStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var form = (0, _form.euiFormVariables)(euiThemeContext);
  return {
    // Base
    euiListGroup: _ref2,
    // Variants
    flush: _ref,
    bordered: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";border:", euiTheme.border.thin, ";;label:bordered;"),
    maxWidthDefault: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('max-width', form.maxWidth), ";;label:maxWidthDefault;"),
    // Gutter sizes
    none: /*#__PURE__*/(0, _react.css)(";label:none;"),
    s: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.s, ";gap:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)("padding:", euiTheme.size.base, ";gap:", euiTheme.size.base, ";;label:m;")
  };
};
exports.euiListGroupStyles = euiListGroupStyles;