"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImageFullScreenWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _focus_trap = require("../focus_trap");
var _overlay_mask = require("../overlay_mask");
var _icon = require("../icon");
var _services = require("../../services");
var _inner_text = require("../inner_text");
var _image_fullscreen_wrapper = require("./image_fullscreen_wrapper.styles");
var _image_button = require("./image_button");
var _image_button2 = require("./image_button.styles");
var _image_caption = require("./image_caption");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
var EuiImageFullScreenWrapper = function EuiImageFullScreenWrapper(_ref) {
  var alt = _ref.alt,
    hasShadow = _ref.hasShadow,
    caption = _ref.caption,
    children = _ref.children,
    setIsFullScreen = _ref.setIsFullScreen,
    wrapperProps = _ref.wrapperProps,
    isFullWidth = _ref.isFullWidth,
    fullScreenIconColor = _ref.fullScreenIconColor,
    onFullScreen = _ref.onFullScreen;
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _image_fullscreen_wrapper.euiImageFullscreenWrapperStyles)(euiTheme);
  var cssStyles = [styles.euiImageFullscreenWrapper];
  var classes = (0, _classnames.default)('euiImageFullScreenWrapper', wrapperProps && wrapperProps.className);
  var onKeyDown = function onKeyDown(event) {
    if (event.key === _services.keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      closeFullScreen();
    }
  };
  var closeFullScreen = function closeFullScreen() {
    setIsFullScreen(false);
    onFullScreen === null || onFullScreen === void 0 ? void 0 : onFullScreen(false);
  };
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    optionalCaptionRef = _useInnerText2[0],
    optionalCaptionText = _useInnerText2[1];
  var iconStyles = (0, _image_button2.euiImageButtonIconStyles)(euiTheme);
  var cssIconStyles = [iconStyles.euiImageButton__icon, iconStyles.closeFullScreen];
  return (0, _react2.jsx)(_overlay_mask.EuiOverlayMask, {
    "data-test-subj": "fullScreenOverlayMask"
  }, (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
    scrollLock: true,
    preventScrollOnFocus: true,
    onClickOutside: closeFullScreen
  }, (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("figure", _extends({
    "aria-label": optionalCaptionText,
    css: cssStyles
  }, wrapperProps, {
    className: classes
  }), (0, _react2.jsx)(_image_button.EuiImageButton, {
    hasAlt: !!alt,
    hasShadow: hasShadow,
    onClick: closeFullScreen,
    onKeyDown: onKeyDown,
    "data-test-subj": "deactivateFullScreenButton",
    isFullScreen: true,
    isFullWidth: isFullWidth,
    fullScreenIconColor: fullScreenIconColor
  }, children), (0, _react2.jsx)(_image_caption.EuiImageCaption, {
    caption: caption,
    ref: optionalCaptionRef,
    isOnOverlayMask: true
  })), (0, _react2.jsx)(_icon.EuiIcon, {
    type: "fullScreenExit",
    color: "ghost",
    css: cssIconStyles
  }))));
};
exports.EuiImageFullScreenWrapper = EuiImageFullScreenWrapper;
EuiImageFullScreenWrapper.propTypes = {
  isFullWidth: _propTypes.default.bool.isRequired,
  setIsFullScreen: _propTypes.default.func.isRequired
};