"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiImage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _image_wrapper = require("./image_wrapper");
var _image = require("./image.styles");
var _image_fullscreen_wrapper = require("./image_fullscreen_wrapper");
var _image_types = require("./image_types");
var _react2 = require("@emotion/react");
var _excluded = ["className", "alt", "url", "src", "size", "hasShadow", "style", "wrapperProps", "fullScreenIconColor", "allowFullScreen", "caption", "float", "margin", "onFullScreen"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiImage = function EuiImage(_ref) {
  var className = _ref.className,
    alt = _ref.alt,
    url = _ref.url,
    src = _ref.src,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'original' : _ref$size,
    hasShadow = _ref.hasShadow,
    style = _ref.style,
    wrapperProps = _ref.wrapperProps,
    fullScreenIconColor = _ref.fullScreenIconColor,
    allowFullScreen = _ref.allowFullScreen,
    caption = _ref.caption,
    float = _ref.float,
    margin = _ref.margin,
    onFullScreen = _ref.onFullScreen,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isFullScreen = _useState2[0],
    setIsFullScreen = _useState2[1];
  var isNamedSize = typeof size === 'string' && _image_types.SIZES.includes(size);
  var classes = (0, _classnames.default)('euiImage', className);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _image.euiImageStyles)(euiTheme);
  var cssStyles = [styles.euiImage, isNamedSize && styles[size], !isNamedSize && styles.customSize, hasShadow && styles.hasShadow];
  var cssIsFullScreenStyles = [styles.euiImage, styles.isFullScreen];
  var isCustomSize = !isNamedSize && size !== 'original';
  var customSize = typeof size === 'string' ? size : "".concat(size, "px");
  var imageStyleWithCustomSize = isCustomSize ? _objectSpread(_objectSpread({}, style), {}, {
    maxWidth: customSize,
    maxHeight: customSize
  }) : style;
  var isFullWidth = size === 'fullWidth';
  var commonWrapperProps = {
    hasShadow: hasShadow,
    wrapperProps: wrapperProps,
    setIsFullScreen: setIsFullScreen,
    fullScreenIconColor: fullScreenIconColor,
    isFullWidth: isFullWidth,
    allowFullScreen: allowFullScreen,
    alt: alt,
    caption: caption,
    float: float,
    margin: margin,
    onFullScreen: onFullScreen
  };
  var commonImgProps = _objectSpread({
    className: classes,
    src: src || url
  }, rest);
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_image_wrapper.EuiImageWrapper, commonWrapperProps, (0, _react2.jsx)("img", _extends({
    alt: alt,
    css: cssStyles,
    style: imageStyleWithCustomSize
  }, commonImgProps))), allowFullScreen && isFullScreen && (0, _react2.jsx)(_image_fullscreen_wrapper.EuiImageFullScreenWrapper, commonWrapperProps, (0, _react2.jsx)("img", _extends({
    alt: alt,
    css: cssIsFullScreenStyles,
    style: style
  }, commonImgProps))));
};
exports.EuiImage = EuiImage;
EuiImage.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Requires either `src` or `url` but defaults to using `src` if both are provided
       */
  src: _propTypes.default.string,
  url: _propTypes.default.string,
  /**
       * Alt text should describe the image to aid screen reader users. See
       * https://webaim.org/techniques/alttext/ for a guide on writing
       * effective alt text.
       *
       * If no meaningful description exists, or if the image is adequately
       * described by the surrounding text, pass an empty string.
       */
  alt: _propTypes.default.string.isRequired,
  /**
       * Provides a visible caption to the image
       */
  caption: _propTypes.default.node,
  /**
       * Accepts `s` / `m` / `l` / `xl` / `original` / `fullWidth` / or a CSS size of `number` or `string`.
       * `fullWidth` will set the figure to stretch to 100% of its container.
       * `string` and `number` types will max both the width or height, whichever is greater.
       */
  size: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),
  /**
       * Float the image to the left or right. Useful in large text blocks.
       */
  float: _propTypes.default.any,
  /**
       * Margin around the image.
       */
  margin: _propTypes.default.any,
  /**
       * When set to `true` (default) will apply a slight shadow to the image
       */
  hasShadow: _propTypes.default.bool,
  /**
       * When set to `true` will make the image clickable to a larger version
       */
  allowFullScreen: _propTypes.default.bool,
  /**
       * Callback when the image is clicked and `allowFullScreen` is `true`
       */
  onFullScreen: _propTypes.default.func,
  /**
       * Changes the color of the icon that floats above the image when it can be clicked to fullscreen.
       * The default value of `light` is fine unless your image has a white background, in which case you should change it to `dark`.
       */
  fullScreenIconColor: _propTypes.default.oneOf(["light", "dark"]),
  /**
       * Props to add to the wrapping figure element
       */
  wrapperProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  })
};