"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _avatar = require("../avatar");
var _flex = require("../flex");
var _header_breadcrumbs = require("./header_breadcrumbs");
var _header = require("./header");
var _header_logo = require("./header_logo");
var _header_section = require("./header_section");
var _icon = require("../icon");
var _key_pad_menu = require("../key_pad_menu");
var _link = require("../link");
var _popover = require("../popover");
var _selectable = require("../selectable");
var _spacer = require("../spacer");
var _text = require("../text");
var _services = require("../../services");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
var Header = function Header() {
  var renderLogo = function renderLogo() {
    return (0, _react2.jsx)(_header_logo.EuiHeaderLogo, {
      iconType: "logoElastic",
      href: "#",
      onClick: function onClick(e) {
        return e.preventDefault();
      },
      "aria-label": "Go to home page"
    });
  };
  var renderBreadcrumbs = function renderBreadcrumbs() {
    var breadcrumbs = [{
      text: 'Management',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      },
      'data-test-subj': 'breadcrumbsAnimals',
      className: 'customClass'
    }, {
      text: 'Truncation test is here for a really long item',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      }
    }, {
      text: 'Hidden',
      'data-test-subj': 'cy-breadcrumb-hidden',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      }
    }, {
      text: 'Users',
      href: '#',
      onClick: function onClick(e) {
        e.preventDefault();
      }
    }, {
      text: 'Create'
    }];
    return (0, _react2.jsx)(_header_breadcrumbs.EuiHeaderBreadcrumbs, {
      "aria-label": "Header breadcrumbs example",
      breadcrumbs: breadcrumbs
    });
  };
  var search = (0, _react2.jsx)(_selectable.EuiSelectableTemplateSitewide, {
    options: [],
    searchProps: {
      compressed: true
    },
    popoverButton: (0, _react2.jsx)(_header_section.EuiHeaderSectionItemButton, {
      "aria-label": "Sitewide search"
    }, (0, _react2.jsx)(_icon.EuiIcon, {
      type: "search",
      size: "m"
    })),
    emptyMessage: (0, _react2.jsx)(_selectable.EuiSelectableMessage, {
      style: {
        minHeight: 300
      },
      "data-test-subj": "cy-search-menu"
    }, (0, _react2.jsx)("p", null, "Please see the component page for", ' ', (0, _react2.jsx)("strong", null, "EuiSelectableTemplateSitewide"), "on how to configure your sitewide search."))
  });
  return (0, _react2.jsx)(_header.EuiHeader, null, (0, _react2.jsx)(_header_section.EuiHeaderSection, {
    grow: false
  }, (0, _react2.jsx)(_header_section.EuiHeaderSectionItem, {
    border: "right"
  }, renderLogo()), (0, _react2.jsx)(_header_section.EuiHeaderSectionItem, {
    border: "right"
  }, (0, _react2.jsx)(HeaderSpacesMenu, null))), renderBreadcrumbs(), (0, _react2.jsx)(_header_section.EuiHeaderSection, {
    side: "right"
  }, (0, _react2.jsx)(_header_section.EuiHeaderSectionItem, null, search), (0, _react2.jsx)(_header_section.EuiHeaderSectionItem, null, (0, _react2.jsx)(HeaderUserMenu, null)), (0, _react2.jsx)(_header_section.EuiHeaderSectionItem, null, (0, _react2.jsx)(HeaderAppMenu, null))));
};
var HeaderUserMenu = function HeaderUserMenu() {
  var headerUserPopoverId = (0, _services.useGeneratedHtmlId)({
    prefix: 'headerUserPopover'
  });
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var onMenuButtonClick = function onMenuButtonClick() {
    setIsOpen(!isOpen);
  };
  var closeMenu = function closeMenu() {
    setIsOpen(false);
  };
  var button = (0, _react2.jsx)(_header_section.EuiHeaderSectionItemButton, {
    "aria-controls": headerUserPopoverId,
    "aria-expanded": isOpen,
    "aria-haspopup": "true",
    "aria-label": "Account menu",
    onClick: onMenuButtonClick
  }, (0, _react2.jsx)(_avatar.EuiAvatar, {
    name: "John Username",
    size: "s"
  }));
  return (0, _react2.jsx)(_popover.EuiPopover, {
    id: headerUserPopoverId,
    button: button,
    isOpen: isOpen,
    anchorPosition: "downRight",
    closePopover: closeMenu,
    panelPaddingSize: "none",
    "data-test-subj": "cy-account-menu"
  }, (0, _react2.jsx)("div", {
    style: {
      width: 320
    }
  }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "m",
    className: "euiHeaderProfile",
    responsive: false
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_avatar.EuiAvatar, {
    name: "John Username",
    size: "xl"
  })), (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_text.EuiText, null, (0, _react2.jsx)("p", null, "John Username")), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "m"
  }), (0, _react2.jsx)(_flex.EuiFlexGroup, null, (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_link.EuiLink, null, "Edit profile")), (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_link.EuiLink, null, "Log out")))))))));
};
var HeaderSpacesMenu = function HeaderSpacesMenu() {
  var headerSpacesPopoverId = (0, _services.useGeneratedHtmlId)({
    prefix: 'headerSpacesPopover'
  });
  var spacesValues = [{
    label: 'Sales team',
    prepend: (0, _react2.jsx)(_avatar.EuiAvatar, {
      type: "space",
      name: "Sales Team",
      size: "s"
    }),
    checked: 'on'
  }, {
    label: 'Engineering',
    prepend: (0, _react2.jsx)(_avatar.EuiAvatar, {
      type: "space",
      name: "Engineering",
      size: "s"
    })
  }];
  var _useState3 = (0, _react.useState)(spacesValues),
    _useState4 = _slicedToArray(_useState3, 2),
    spaces = _useState4[0],
    setSpaces = _useState4[1];
  var _useState5 = (0, _react.useState)(spaces.filter(function (option) {
      return option.checked;
    })[0]),
    _useState6 = _slicedToArray(_useState5, 2),
    selectedSpace = _useState6[0],
    setSelectedSpace = _useState6[1];
  var _useState7 = (0, _react.useState)(false),
    _useState8 = _slicedToArray(_useState7, 2),
    isOpen = _useState8[0],
    setIsOpen = _useState8[1];
  var isListExtended = function isListExtended() {
    return spaces.length > 4 ? true : false;
  };
  var onMenuButtonClick = function onMenuButtonClick() {
    setIsOpen(!isOpen);
  };
  var closePopover = function closePopover() {
    setIsOpen(false);
  };
  var onChange = function onChange(options) {
    setSpaces(options);
    setSelectedSpace(options.filter(function (option) {
      return option.checked;
    })[0]);
    setIsOpen(false);
  };
  var button = (0, _react2.jsx)(_header_section.EuiHeaderSectionItemButton, {
    "aria-controls": headerSpacesPopoverId,
    "aria-expanded": isOpen,
    "aria-haspopup": "true",
    "aria-label": "Spaces menu",
    onClick: onMenuButtonClick
  }, selectedSpace.prepend);
  return (0, _react2.jsx)(_popover.EuiPopover, {
    id: headerSpacesPopoverId,
    button: button,
    isOpen: isOpen,
    anchorPosition: "downLeft",
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, (0, _react2.jsx)(_selectable.EuiSelectable, {
    searchable: isListExtended(),
    searchProps: {
      placeholder: 'Find a space',
      compressed: true
    },
    options: spaces,
    singleSelection: "always",
    style: {
      width: 300
    },
    onChange: onChange,
    listProps: {
      rowHeight: 40,
      showIcons: false
    },
    "data-test-subj": "cy-spaces-menu"
  }, function (list, search) {
    return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_popover.EuiPopoverTitle, {
      paddingSize: "s"
    }, search || 'Your spaces'), list);
  }));
};
var HeaderAppMenu = function HeaderAppMenu() {
  var headerAppPopoverId = (0, _services.useGeneratedHtmlId)({
    prefix: 'headerAppPopover'
  });
  var headerAppKeyPadMenuId = (0, _services.useGeneratedHtmlId)({
    prefix: 'headerAppKeyPadMenu'
  });
  var _useState9 = (0, _react.useState)(false),
    _useState10 = _slicedToArray(_useState9, 2),
    isOpen = _useState10[0],
    setIsOpen = _useState10[1];
  var onMenuButtonClick = function onMenuButtonClick() {
    setIsOpen(!isOpen);
  };
  var closeMenu = function closeMenu() {
    setIsOpen(false);
  };
  var button = (0, _react2.jsx)(_header_section.EuiHeaderSectionItemButton, {
    "aria-controls": headerAppKeyPadMenuId,
    "aria-expanded": isOpen,
    "aria-haspopup": "true",
    "aria-label": "Apps menu with 1 new app",
    notification: "1",
    onClick: onMenuButtonClick
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "apps",
    size: "m"
  }));
  return (0, _react2.jsx)(_popover.EuiPopover, {
    id: headerAppPopoverId,
    button: button,
    isOpen: isOpen,
    anchorPosition: "downRight",
    closePopover: closeMenu
  }, (0, _react2.jsx)(_key_pad_menu.EuiKeyPadMenu, {
    id: headerAppKeyPadMenuId,
    style: {
      width: 288
    },
    "data-test-subj": "cy-apps-menu"
  }, (0, _react2.jsx)(_key_pad_menu.EuiKeyPadMenuItem, {
    label: "Discover"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "discoverApp",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu.EuiKeyPadMenuItem, {
    label: "Dashboard"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "dashboardApp",
    size: "l"
  })), (0, _react2.jsx)(_key_pad_menu.EuiKeyPadMenuItem, {
    label: "Dev Tools"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    type: "devToolsApp",
    size: "l"
  }))));
};
beforeEach(function () {
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount((0, _react2.jsx)(Header, null));
});
describe('EuiHeader', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when Spaces menu is expanded', function () {
      cy.get('button[aria-label="Spaces menu"]').realClick();
      cy.get('div[data-test-subj="cy-spaces-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when Account menu is expanded', function () {
      cy.get('button[aria-label="Account menu"]').realClick();
      cy.get('div[data-test-subj="cy-account-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when Sitewide search is expanded', function () {
      cy.get('button[aria-label="Sitewide search"]').realClick();
      cy.get('div[data-test-subj="cy-search-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when Apps menu is expanded', function () {
      cy.get('button[aria-label="Apps menu with 1 new app"]').realClick();
      cy.get('ul[data-test-subj="cy-apps-menu"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when a hidden breadcrumb is expanded', function () {
      cy.get('button[aria-label="See collapsed breadcrumbs"]').realClick();
      cy.get('a[data-test-subj="cy-breadcrumb-hidden"]').should('exist');
      cy.checkAxe();
    });
  });
});