"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeTicks = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _inner_text = require("../../inner_text");
var _utils = require("./utils");
var _range_ticks = require("./range_ticks.styles");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var EuiTickValue = function EuiTickValue(_ref) {
  var disabled = _ref.disabled,
    ticks = _ref.ticks,
    min = _ref.min,
    max = _ref.max,
    value = _ref.value,
    onChange = _ref.onChange,
    percentageWidth = _ref.percentageWidth,
    tickValue = _ref.tickValue,
    compressed = _ref.compressed,
    trackWidth = _ref.trackWidth;
  var euiTheme = (0, _services.useEuiTheme)();
  var hasCustomTicks = !!ticks;
  var tickObject = (0, _react.useMemo)(function () {
    return hasCustomTicks ? ticks.find(function (o) {
      return o.value === tickValue;
    }) : {
      value: tickValue,
      label: tickValue
    };
  }, [hasCustomTicks, ticks, tickValue]);
  var isMinTick = (tickObject === null || tickObject === void 0 ? void 0 : tickObject.value) === min;
  var isMaxTick = (tickObject === null || tickObject === void 0 ? void 0 : tickObject.value) === max;
  var label = tickObject ? tickObject.label : tickValue;

  // Math worked out by trial and error
  // Shifts the label into the reserved margin of EuiRangeTrack
  var labelShiftVal = (0, _react.useMemo)(function () {
    return (isMinTick || isMaxTick) && label.length > 3 ? Math.min(label.length * 0.25, 1.25) : 0;
  }, [isMinTick, isMaxTick, label]);
  var tickStyle = (0, _react.useMemo)(function () {
    var styles = {};
    var shift = "-".concat(labelShiftVal, "em");
    if (isMaxTick && labelShiftVal) {
      styles.right = '0%';
      styles.marginRight = shift;
    } else {
      var position = (0, _utils.calculateThumbPosition)(tickValue, min, max, trackWidth);
      var thumbOffset = labelShiftVal ? 0 : _utils.EUI_THUMB_SIZE / 2;
      styles.left = "calc(".concat(position, "% + ").concat(thumbOffset, "px)");
      if (labelShiftVal) styles.marginLeft = shift;
    }
    styles.maxWidth = hasCustomTicks ? undefined : "".concat(percentageWidth, "%");
    return (0, _global_styling.logicalStyles)(styles);
  }, [isMaxTick, labelShiftVal, trackWidth, tickValue, min, max, hasCustomTicks, percentageWidth]);

  // Some ticks need an actual DOM element instead of using a ::before
  var pseudoTick = tickObject && !!labelShiftVal && (isMinTick || isMaxTick);
  var pseudoShift = (0, _react.useMemo)(function () {
    if (!labelShiftVal) return {};
    var marginProperty = isMaxTick ? 'marginRight' : 'marginLeft';
    var tickOffset = euiTheme.euiTheme.size.xs; // xs derived from .euiRangeTicks left/right offset

    return (0, _global_styling.logicalStyles)(_defineProperty({}, marginProperty, "calc(".concat(labelShiftVal, "em + ").concat(tickOffset, ")")));
  }, [labelShiftVal, isMaxTick, euiTheme.euiTheme.size.xs]);
  var styles = (0, _range_ticks.euiRangeTickStyles)(euiTheme);
  var cssTickStyles = [styles.euiRangeTick, value === String(tickValue) && styles.selected, hasCustomTicks && styles.isCustom, labelShiftVal && isMinTick && styles.isMin, labelShiftVal && isMaxTick && styles.isMax, !pseudoTick && styles.hasPseudoTickMark, compressed ? styles.compressed : styles.regular];
  var _useInnerText = (0, _inner_text.useInnerText)(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    ref = _useInnerText2[0],
    innerText = _useInnerText2[1];
  return (0, _react2.jsx)("button", {
    type: "button",
    className: "euiRangeTick",
    css: cssTickStyles,
    value: tickValue,
    disabled: disabled,
    onClick: onChange,
    style: tickStyle,
    tabIndex: -1,
    ref: ref,
    title: typeof label === 'string' ? label : innerText
  }, pseudoTick && (0, _react2.jsx)("span", {
    className: "euiRangeTick__pseudo",
    css: styles.euiRangeTick__pseudo,
    "aria-hidden": true,
    style: pseudoShift
  }), label);
};
EuiTickValue.propTypes = {
  tickSequence: _propTypes.default.arrayOf(_propTypes.default.number.isRequired).isRequired,
  trackWidth: _propTypes.default.number.isRequired,
  onChange: _propTypes.default.func,
  value: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired, _propTypes.default.any.isRequired]),
  max: _propTypes.default.number.isRequired,
  min: _propTypes.default.number.isRequired,
  /**
     * The number to increment or decrement between each interval
     * @default 1
     */
  step: _propTypes.default.number,
  tickValue: _propTypes.default.any.isRequired,
  percentageWidth: _propTypes.default.number.isRequired
};
var EuiRangeTicks = function EuiRangeTicks(props) {
  var ticks = props.ticks,
    tickSequence = props.tickSequence,
    max = props.max,
    min = props.min,
    _props$tickInterval = props.tickInterval,
    tickInterval = _props$tickInterval === void 0 ? 1 : _props$tickInterval,
    compressed = props.compressed;

  // Calculate the width of each tick mark
  var percentageWidth = (0, _react.useMemo)(function () {
    return tickInterval / (max - min + tickInterval) * 100;
  }, [tickInterval, min, max]);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _range_ticks.euiRangeTicksStyles)(euiTheme);
  var cssStyles = [styles.euiRangeTicks, compressed ? styles.compressed : styles.regular, ticks && styles.isCustom];
  return (0, _react2.jsx)("div", {
    className: "euiRangeTicks",
    css: cssStyles
  }, tickSequence.map(function (tickValue) {
    return (0, _react2.jsx)(EuiTickValue, _extends({
      key: tickValue
    }, props, {
      percentageWidth: percentageWidth,
      tickValue: tickValue
    }));
  }));
};
exports.EuiRangeTicks = EuiRangeTicks;
EuiRangeTicks.propTypes = {
  tickSequence: _propTypes.default.arrayOf(_propTypes.default.number.isRequired).isRequired,
  trackWidth: _propTypes.default.number.isRequired,
  onChange: _propTypes.default.func,
  value: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired, _propTypes.default.any.isRequired]),
  max: _propTypes.default.number.isRequired,
  min: _propTypes.default.number.isRequired,
  step: _propTypes.default.number
};