"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiRangeLevelsStyles = exports.euiRangeLevelStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../../services");
var _range_levels_colors = require("./range_levels_colors");
var _range = require("./range.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiRangeLevelsStyles = function euiRangeLevelsStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  var isColorDark = colorMode === 'DARK';
  var stripeColor = isColorDark ? euiTheme.colors.ink : euiTheme.colors.ghost;
  var stripesBackground = "repeating-linear-gradient(\n    -45deg,\n    ".concat((0, _services.transparentize)(stripeColor, 0.5), ",\n    ").concat((0, _services.transparentize)(stripeColor, 0.5), " 25%,\n    ").concat((0, _services.transparentize)(stripeColor, 0.7), " 25%,\n    ").concat((0, _services.transparentize)(stripeColor, 0.7), " 50%,\n    ").concat((0, _services.transparentize)(stripeColor, 0.5), " 50%\n  )");
  return {
    euiRangeLevels: /*#__PURE__*/(0, _react.css)("display:flex;justify-content:stretch;position:absolute;inset-inline:0;inset-block-start:", range.trackTopPositionWithoutTicks, ";z-index:", range.levelsZIndex, ";;label:euiRangeLevels;"),
    hasRange: /*#__PURE__*/(0, _react.css)("&::after{content:'';position:absolute;block-size:", range.trackHeight, ";inline-size:100%;background-image:", stripesBackground, ";background-size:", euiTheme.size.xs, " ", euiTheme.size.xs, ";border-radius:", range.trackBorderRadius, ";};label:hasRange;"),
    hasTicks: /*#__PURE__*/(0, _react.css)("inset-block-start:", range.trackTopPositionWithTicks, ";;label:hasTicks;")
  };
};
exports.euiRangeLevelsStyles = euiRangeLevelsStyles;
var euiRangeLevelStyles = function euiRangeLevelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var range = (0, _range.euiRangeVariables)(euiThemeContext);
  return {
    euiRangeLevel: /*#__PURE__*/(0, _react.css)("display:block;position:absolute;block-size:", range.trackHeight, ";margin-block:0;&:first-child{margin-inline-start:0;border-start-start-radius:", range.trackBorderRadius, ";border-end-start-radius:", range.trackBorderRadius, ";}&:last-child{margin-inline-end:0;border-start-end-radius:", range.trackBorderRadius, ";border-end-end-radius:", range.trackBorderRadius, ";};label:euiRangeLevel;"),
    primary: /*#__PURE__*/(0, _react.css)("background-color:", (0, _range_levels_colors.euiRangeLevelColor)('primary', euiTheme), ";;label:primary;"),
    success: /*#__PURE__*/(0, _react.css)("background-color:", (0, _range_levels_colors.euiRangeLevelColor)('success', euiTheme), ";;label:success;"),
    warning: /*#__PURE__*/(0, _react.css)("background-color:", (0, _range_levels_colors.euiRangeLevelColor)('warning', euiTheme), ";;label:warning;"),
    danger: /*#__PURE__*/(0, _react.css)("background-color:", (0, _range_levels_colors.euiRangeLevelColor)('danger', euiTheme), ";;label:danger;"),
    customColor: /*#__PURE__*/(0, _react.css)(";label:customColor;")
  };
};
exports.euiRangeLevelStyles = euiRangeLevelStyles;