"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRangeClass = exports.EuiRange = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _number = require("../../../services/number");
var _popover = require("../../popover");
var _services = require("../../../services/");
var _eui_form_context = require("../eui_form_context");
var _range_levels_colors = require("./range_levels_colors");
var _range_highlight = require("./range_highlight");
var _range_input = require("./range_input");
var _range_label = require("./range_label");
var _range_slider = require("./range_slider");
var _range_tooltip = require("./range_tooltip");
var _range_track = require("./range_track");
var _range_wrapper = require("./range_wrapper");
var _range = require("./range.styles");
var _i18n = require("../../i18n");
var _react2 = require("@emotion/react");
var _excluded = ["className", "compressed", "disabled", "fullWidth", "isLoading", "readOnly", "id", "max", "min", "name", "step", "showLabels", "showInput", "showTicks", "tickInterval", "ticks", "levels", "showRange", "showValue", "valueAppend", "valuePrepend", "onBlur", "onChange", "onFocus", "value", "tabIndex", "isInvalid", "theme"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var EuiRangeClass = /*#__PURE__*/function (_Component) {
  _inherits(EuiRangeClass, _Component);
  var _super = _createSuper(EuiRangeClass);
  function EuiRangeClass() {
    var _this;
    _classCallCheck(this, EuiRangeClass);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "preventPopoverClose", false);
    _defineProperty(_assertThisInitialized(_this), "state", {
      id: _this.props.id || (0, _services.htmlIdGenerator)()(),
      isPopoverOpen: false
    });
    _defineProperty(_assertThisInitialized(_this), "handleOnChange", function (e) {
      var isValid = (0, _number.isWithinRange)(_this.props.min, _this.props.max, e.currentTarget.value);
      if (_this.props.onChange) {
        _this.props.onChange(e, isValid);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onInputFocus", function (e) {
      if (_this.props.onFocus) {
        _this.props.onFocus(e);
      }
      _this.setState({
        isPopoverOpen: true
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onInputBlur", function (e) {
      return setTimeout(function () {
        // Safari does not recognize any focus-related eventing for input[type=range]
        // making it impossible to capture its state using active/focus/relatedTarget
        // Instead, a prevention flag is set on mousedown, with a waiting period here.
        // Mousedown is viable because in the popover case, it is inaccessible via keyboard (intentionally)
        if (_this.preventPopoverClose) {
          _this.preventPopoverClose = false;
          return;
        }
        if (_this.props.onBlur) {
          _this.props.onBlur(e);
        }
        _this.closePopover();
      }, 200);
    });
    _defineProperty(_assertThisInitialized(_this), "closePopover", function () {
      _this.preventPopoverClose = false;
      _this.setState({
        isPopoverOpen: false
      });
    });
    return _this;
  }
  _createClass(EuiRangeClass, [{
    key: "isValid",
    get: function get() {
      return (0, _number.isWithinRange)(this.props.min, this.props.max, this.props.value || '');
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _ref = this.context,
        defaultFullWidth = _ref.defaultFullWidth;
      var _this$props = this.props,
        className = _this$props.className,
        compressed = _this$props.compressed,
        disabled = _this$props.disabled,
        _this$props$fullWidth = _this$props.fullWidth,
        fullWidth = _this$props$fullWidth === void 0 ? defaultFullWidth : _this$props$fullWidth,
        isLoading = _this$props.isLoading,
        readOnly = _this$props.readOnly,
        propsId = _this$props.id,
        max = _this$props.max,
        min = _this$props.min,
        name = _this$props.name,
        step = _this$props.step,
        showLabels = _this$props.showLabels,
        showInput = _this$props.showInput,
        showTicks = _this$props.showTicks,
        tickInterval = _this$props.tickInterval,
        ticks = _this$props.ticks,
        levels = _this$props.levels,
        showRange = _this$props.showRange,
        showValue = _this$props.showValue,
        valueAppend = _this$props.valueAppend,
        valuePrepend = _this$props.valuePrepend,
        onBlur = _this$props.onBlur,
        onChange = _this$props.onChange,
        onFocus = _this$props.onFocus,
        value = _this$props.value,
        tabIndex = _this$props.tabIndex,
        isInvalid = _this$props.isInvalid,
        theme = _this$props.theme,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var id = this.state.id;
      var digitTolerance = Math.max(String(min).length, String(max).length);
      var showInputOnly = showInput === 'inputWithPopover';
      var canShowDropdown = showInputOnly && !readOnly && !disabled;
      var theInput = !!showInput ? (0, _react2.jsx)(_range_input.EuiRangeInput, _extends({
        id: id,
        min: min,
        max: max,
        digitTolerance: digitTolerance,
        step: step,
        value: value,
        readOnly: readOnly,
        disabled: disabled,
        compressed: compressed,
        onChange: this.handleOnChange,
        name: name,
        onFocus: canShowDropdown ? this.onInputFocus : onFocus,
        onBlur: canShowDropdown ? this.onInputBlur : onBlur,
        fullWidth: showInputOnly && fullWidth,
        isLoading: showInputOnly && isLoading,
        isInvalid: isInvalid,
        autoSize: !showInputOnly
      }, rest)) : null;
      var classes = (0, _classnames.default)('euiRange', className);
      var styles = (0, _range.euiRangeStyles)(theme);
      var cssStyles = [styles.euiRange, showInput && styles.hasInput];
      var thumbColor = levels && (0, _range_levels_colors.getLevelColor)(levels, Number(value));
      var sliderScreenReaderInstructions = (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiRange.sliderScreenReaderInstructions",
        default: "You are in a custom range slider. Use the Up and Down arrow keys to change the value."
      });
      var theRange = (0, _react2.jsx)(_range_wrapper.EuiRangeWrapper, {
        className: classes,
        css: cssStyles,
        fullWidth: fullWidth,
        compressed: compressed
      }, showLabels && (0, _react2.jsx)(_range_label.EuiRangeLabel, {
        side: "min",
        disabled: disabled
      }, min), (0, _react2.jsx)(_range_track.EuiRangeTrack, {
        disabled: disabled,
        compressed: compressed,
        max: max,
        min: min,
        step: step,
        showTicks: showTicks,
        tickInterval: tickInterval,
        ticks: ticks,
        levels: levels,
        onChange: this.handleOnChange,
        value: value,
        "aria-hidden": !!showInput,
        showRange: showRange
      }, function (trackWidth) {
        return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_range_slider.EuiRangeSlider, _extends({
          id: showInput ? undefined : id // Attach id only to the input if there is one
          ,
          name: name,
          min: min,
          max: max,
          step: step,
          value: value,
          disabled: disabled,
          onChange: _this2.handleOnChange,
          showTicks: showTicks,
          showRange: showRange,
          tabIndex: showInput ? -1 : tabIndex,
          onMouseDown: showInputOnly ? function () {
            return _this2.preventPopoverClose = true;
          } : undefined,
          onFocus: showInput === true ? undefined : onFocus,
          onBlur: showInputOnly ? _this2.onInputBlur : onBlur,
          "aria-hidden": !!showInput,
          thumbColor: thumbColor
        }, rest)), showRange && _this2.isValid && (0, _react2.jsx)(_range_highlight.EuiRangeHighlight, {
          showTicks: showTicks,
          min: Number(min),
          max: Number(max),
          lowerValue: Number(min),
          upperValue: Number(value),
          levels: levels,
          trackWidth: trackWidth
        }), showValue && !!String(value).length && (0, _react2.jsx)(_range_tooltip.EuiRangeTooltip, {
          value: value,
          max: max,
          min: min,
          name: name,
          showTicks: showTicks,
          valuePrepend: valuePrepend,
          valueAppend: valueAppend
        }));
      }), showLabels && (0, _react2.jsx)(_range_label.EuiRangeLabel, {
        side: "max",
        disabled: disabled
      }, max), showInput && !showInputOnly && (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("div", {
        className: showTicks || ticks ? 'euiRange__slimHorizontalSpacer' : 'euiRange__horizontalSpacer',
        css: showTicks || ticks ? styles.euiRange__slimHorizontalSpacer : styles.euiRange__horizontalSpacer
      }), theInput));
      var thePopover = showInputOnly ? (0, _react2.jsx)(_popover.EuiInputPopover, {
        className: "euiRange__popover",
        input: theInput // `showInputOnly` confirms existence
        ,
        fullWidth: fullWidth,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        disableFocusTrap: true,
        popoverScreenReaderText: sliderScreenReaderInstructions
      }, theRange) : undefined;
      return thePopover ? thePopover : theRange;
    }
  }]);
  return EuiRangeClass;
}(_react.Component);
exports.EuiRangeClass = EuiRangeClass;
_defineProperty(EuiRangeClass, "contextType", _eui_form_context.FormContext);
_defineProperty(EuiRangeClass, "defaultProps", {
  min: 0,
  max: 100,
  step: 1,
  compressed: false,
  isLoading: false,
  showLabels: false,
  showInput: false,
  showRange: false,
  showTicks: false,
  showValue: false,
  levels: []
});
EuiRangeClass.propTypes = {
  /**
     * Shows a tooltip styled value
     */
  showValue: _propTypes.default.bool,
  /**
     * Appends to the tooltip
     */
  valueAppend: _propTypes.default.node,
  /**
     * Prepends to the tooltip
     */
  valuePrepend: _propTypes.default.node,
  /**
     * Only impacts the input rendered by the `showInput` prop.
     * `string` | `ReactElement` or an array of these
     */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
     * Only impacts the input rendered by the `showInput` prop.
     * `string` | `ReactElement` or an array of these
     */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  value: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.number.isRequired]).isRequired,
  onChange: _propTypes.default.func,
  max: _propTypes.default.number.isRequired,
  min: _propTypes.default.number.isRequired,
  /**
     * The number to increment or decrement between each interval
     * @default 1
     */
  step: _propTypes.default.number,
  /**
     * Specified ticks at specified values
     */
  ticks: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.number.isRequired,
    label: _propTypes.default.node.isRequired
  }).isRequired),
  /**
     * Modifies the number of tick marks and at what interval
     */
  tickInterval: _propTypes.default.number,
  /**
     * Create colored indicators for certain intervals.
     * An array of #EuiRangeLevel objects
     */
  levels: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Accepts one of `["primary", "success", "warning", "danger"]` or a valid CSS color value.
       */
    color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,
    css: _propTypes.default.any
  }).isRequired),
  /**
     * Pass `true` to displays an extra input control for direct manipulation.
     * Pass `"inputWithPopover"` to only show the input but show the range in a dropdown.
     */
  showInput: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["inputWithPopover"])]),
  /**
     * Shows static min/max labels on the sides of the range slider
     */
  showLabels: _propTypes.default.bool,
  /**
     * Shows a thick line from min to value
     */
  showRange: _propTypes.default.bool,
  /**
     * Shows clickable tick marks and labels at the given interval (`step`/`tickInterval`)
     */
  showTicks: _propTypes.default.bool,
  id: _propTypes.default.string,
  name: _propTypes.default.string,
  /**
     * Only impacts ticks rendered by `showTicks` or inputs rendered by `showInput`.
     */
  compressed: _propTypes.default.bool,
  /**
     * Only impacts inputs rendered by the `showInput` prop.
     * The range slider itself remains interactable unless `disabled` is applied.
     */
  readOnly: _propTypes.default.bool,
  /**
     * Disables both the range track and any input(s)
     */
  disabled: _propTypes.default.bool,
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: _propTypes.default.bool,
  /**
     * Only impacts inputs rendered when the `showInput` prop is set to `"inputWithPopover"`
     */
  isLoading: _propTypes.default.bool,
  /**
     * Only impacts inputs rendered by the `showInput` prop
     */
  isInvalid: _propTypes.default.bool
};
var EuiRange = (0, _services.withEuiTheme)(EuiRangeClass);
exports.EuiRange = EuiRange;