"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFormVariables = exports.euiFormControlSize = exports.euiCustomControl = void 0;
var _services = require("../../services");
var _global_styling = require("../../global_styling");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var euiFormVariables = function euiFormVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var isColorDark = colorMode === 'DARK';
  var backgroundColor = isColorDark ? (0, _services.shade)(euiTheme.colors.lightestShade, 0.4) : (0, _services.tint)(euiTheme.colors.lightestShade, 0.6);
  var controlHeight = euiTheme.size.xxl;
  var controlCompressedHeight = euiTheme.size.xl;
  var sizes = {
    maxWidth: (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 25;
    }),
    controlHeight: controlHeight,
    controlCompressedHeight: controlCompressedHeight,
    controlPadding: euiTheme.size.m,
    controlCompressedPadding: euiTheme.size.s,
    controlBorderRadius: euiTheme.border.radius.medium,
    controlCompressedBorderRadius: euiTheme.border.radius.small
  };
  var colors = {
    backgroundColor: backgroundColor,
    backgroundDisabledColor: (0, _services.darken)(euiTheme.colors.lightestShade, 0.1),
    backgroundReadOnlyColor: euiTheme.colors.emptyShade,
    borderColor: (0, _services.transparentize)(euiTheme.border.color, 0.9),
    borderDisabledColor: (0, _services.transparentize)(euiTheme.border.color, 0.9),
    controlDisabledColor: euiTheme.colors.mediumShade,
    controlBoxShadow: '0 0 transparent',
    controlPlaceholderText: (0, _services.makeHighContrastColor)(euiTheme.colors.subduedText)(backgroundColor),
    inputGroupLabelBackground: isColorDark ? (0, _services.shade)(euiTheme.colors.lightShade, 0.15) : (0, _services.tint)(euiTheme.colors.lightShade, 0.5),
    inputGroupBorder: 'none'
  };

  // Colors - specific for checkboxes and radios
  var customControlColors = {
    customControlDisabledIconColor: isColorDark ? (0, _services.shade)(euiTheme.colors.mediumShade, 0.38) : (0, _services.tint)(euiTheme.colors.mediumShade, 0.485),
    customControlBorderColor: isColorDark ? (0, _services.shade)(euiTheme.colors.lightestShade, 0.18) : (0, _services.tint)(euiTheme.colors.lightestShade, 0.3)
  };
  var controlLayout = {
    controlLayoutGroupInputHeight: (0, _global_styling.mathWithUnits)(controlHeight, function (x) {
      return x - 2;
    }),
    controlLayoutGroupInputCompressedHeight: (0, _global_styling.mathWithUnits)(controlCompressedHeight, function (x) {
      return x - 2;
    }),
    controlLayoutGroupInputCompressedBorderRadius: euiTheme.border.radius.small
  };
  var iconSizes = {
    controlIconSize: {
      s: euiTheme.size.m,
      m: euiTheme.size.base,
      l: euiTheme.size.l,
      xl: euiTheme.size.xl,
      xxl: euiTheme.size.xxl
    }
  };
  return _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, sizes), colors), customControlColors), iconSizes), controlLayout);
};
exports.euiFormVariables = euiFormVariables;
var euiFormControlSize = function euiFormControlSize(euiThemeContext) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var form = euiFormVariables(euiThemeContext);
  var width = '100%';
  var maxWidth = form.maxWidth;
  if (options.fullWidth) maxWidth = '100%';
  var height = options.height || form.controlHeight;
  if (options.compressed) height = form.controlCompressedHeight;
  if (options.inGroup) height = '100%';
  return "\n    max-inline-size: ".concat(maxWidth, ";\n    inline-size: ").concat(width, ";\n    block-size: ").concat(height, ";\n  ");
};
exports.euiFormControlSize = euiFormControlSize;
var euiCustomControl = function euiCustomControl(euiThemeContext) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var euiTheme = euiThemeContext.euiTheme;
  var form = euiFormVariables(euiThemeContext);
  var type = options.type,
    _options$size = options.size,
    size = _options$size === void 0 ? euiTheme.size.base : _options$size;
  var padddingStyle = '';
  var borderRadiusStyle = '';
  if (size) {
    var borderSize = parseFloat(String(euiTheme.border.width.thin));
    var paddingSize = (0, _global_styling.mathWithUnits)(size, function (x) {
      return (x - borderSize * 2) / 2;
    });
    padddingStyle = "padding: ".concat(paddingSize, ";");
  }
  if (type === 'round') {
    borderRadiusStyle = "border-radius: ".concat(size, ";");
  } else if (type === 'square') {
    borderRadiusStyle = "border-radius: ".concat(form.controlCompressedBorderRadius, ";");
  }
  return "\n    ".concat(padddingStyle, "\n    ").concat(borderRadiusStyle, "\n    border: ").concat(euiTheme.border.width.thin, " solid ").concat(form.customControlBorderColor, ";\n    background: ").concat(euiTheme.colors.emptyShade, " no-repeat center;\n\n    ").concat(_global_styling.euiCanAnimate, " {\n      transition: background-color ").concat(euiTheme.animation.fast, " ease-in,\n              border-color ").concat(euiTheme.animation.fast, " ease-in;\n    }\n  ");
};
exports.euiCustomControl = euiCustomControl;