"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _badge = require("../badge");
var _button = require("../button");
var _form = require("../form");
var _focus_trap = require("./focus_trap");
var _spacer = require("../spacer");
var _panel = require("../panel");
var _text = require("../text");
var _services = require("../../services");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
var CheckboxGroup = function CheckboxGroup() {
  var checkboxGroupItemId__1 = (0, _services.useGeneratedHtmlId)({
    prefix: 'checkboxGroupItem',
    suffix: 'first'
  });
  var checkboxGroupItemId__2 = (0, _services.useGeneratedHtmlId)({
    prefix: 'checkboxGroupItem',
    suffix: 'second'
  });
  var checkboxes = [{
    id: checkboxGroupItemId__1,
    label: 'Option one is checked by default'
  }, {
    id: checkboxGroupItemId__2,
    label: 'Option two'
  }];
  var _useState = (0, _react.useState)(_defineProperty({}, checkboxGroupItemId__1, true)),
    _useState2 = _slicedToArray(_useState, 1),
    checkboxIdToSelectedMap = _useState2[0];
  return (0, _react2.jsx)(_form.EuiCheckboxGroup, {
    options: checkboxes,
    idToSelectedMap: checkboxIdToSelectedMap,
    onChange: function onChange() {}
  });
};
var FocusTrap = function FocusTrap() {
  var _useState4 = (0, _react.useState)(true),
    _useState5 = _slicedToArray(_useState4, 2),
    isDisabled = _useState5[0],
    changeDisabled = _useState5[1];
  var toggleDisabled = function toggleDisabled() {
    return changeDisabled(!isDisabled);
  };
  return (0, _react2.jsx)("div", {
    "data-test-subj": "cy-trap-container"
  }, (0, _react2.jsx)(_badge.EuiBadge, {
    "data-test-subj": "cy-trap-message"
  }, "Trap is ", isDisabled ? 'disabled' : 'enabled'), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "s"
  }), (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
    disabled: isDisabled
  }, (0, _react2.jsx)(_panel.EuiPanel, null, (0, _react2.jsx)(_form.EuiFieldText, {
    "data-test-subj": "cy-input-one",
    placeholder: "Placeholder text first input",
    value: "",
    onChange: function onChange() {},
    "aria-label": "First focusable input"
  }), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "m"
  }), (0, _react2.jsx)(CheckboxGroup, null), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "m"
  }), (0, _react2.jsx)(_button.EuiButton, {
    onClick: toggleDisabled,
    "data-test-subj": "cy-focus-trap-button"
  }, "".concat(!isDisabled ? 'Disable' : 'Enable', " Focus Trap")))), (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "l"
  }), (0, _react2.jsx)(_text.EuiText, null, "The button below is not focusable by keyboard as long as the focus trap is enabled."), (0, _react2.jsx)(_button.EuiButton, {
    onClick: function onClick() {},
    "data-test-subj": "cy-external-button"
  }, "External Focusable Element"));
};
beforeEach(function () {
  cy.viewport(1024, 768); // medium breakpoint
  cy.realMount((0, _react2.jsx)(FocusTrap, null));
});
describe('EuiFocusTrap', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the focus trap is enabled', function () {
      cy.get('button[data-test-subj="cy-focus-trap-button"]').realClick();
      cy.get('span[ data-test-subj="cy-trap-message"]').should('have.text', 'Trap is enabled');
      cy.checkAxe();
    });
  });
  describe('Accessibility checks for keyboard navigation', function () {
    it('allows the button outside the FocusTrap to receive focus', function () {
      cy.repeatRealPress('Tab', 5);
      cy.get('button[data-test-subj="cy-external-button"]').should('have.focus');
      cy.checkAxe();
    });
    it('prevents the button outside the FocusTrap from receiving focus', function () {
      cy.repeatRealPress('Tab', 4);
      cy.realPress('Enter');
      cy.realPress('Tab');
      cy.get('input[data-test-subj="cy-input-one"]').should('have.focus');
      cy.checkAxe();
    });
  });
});