"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TYPES = exports.SIZES = exports.SIDES = exports.PADDING_SIZES = exports.EuiFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _focus_trap = require("../focus_trap");
var _overlay_mask = require("../overlay_mask");
var _button = require("../button");
var _i18n = require("../i18n");
var _resize_observer = require("../observer/resize_observer");
var _portal = require("../portal");
var _accessibility = require("../accessibility");
var _flyout = require("./flyout.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "children", "as", "hideCloseButton", "closeButtonProps", "closeButtonPosition", "onClose", "ownFocus", "side", "size", "paddingSize", "maxWidth", "style", "maskProps", "type", "outsideClickCloses", "pushMinBreakpoint", "focusTrapProps", "includeFixedHeadersInFocusTrap"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var TYPES = ['push', 'overlay'];
exports.TYPES = TYPES;
var SIDES = ['left', 'right'];
exports.SIDES = SIDES;
var SIZES = ['s', 'm', 'l'];
exports.SIZES = SIZES;
/**
 * Custom type checker for named flyout sizes since the prop
 * `size` can also be CSSProperties['width'] (string | number)
 */
function isEuiFlyoutSizeNamed(value) {
  return SIZES.includes(value);
}
var PADDING_SIZES = ['none', 's', 'm', 'l'];
exports.PADDING_SIZES = PADDING_SIZES;
var defaultElement = 'div';
var EuiFlyout = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, ref) {
  var className = _ref.className,
    children = _ref.children,
    as = _ref.as,
    _ref$hideCloseButton = _ref.hideCloseButton,
    hideCloseButton = _ref$hideCloseButton === void 0 ? false : _ref$hideCloseButton,
    closeButtonProps = _ref.closeButtonProps,
    _ref$closeButtonPosit = _ref.closeButtonPosition,
    closeButtonPosition = _ref$closeButtonPosit === void 0 ? 'inside' : _ref$closeButtonPosit,
    onClose = _ref.onClose,
    _ref$ownFocus = _ref.ownFocus,
    ownFocus = _ref$ownFocus === void 0 ? true : _ref$ownFocus,
    _ref$side = _ref.side,
    side = _ref$side === void 0 ? 'right' : _ref$side,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? false : _ref$maxWidth,
    style = _ref.style,
    maskProps = _ref.maskProps,
    _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'overlay' : _ref$type,
    outsideClickCloses = _ref.outsideClickCloses,
    _ref$pushMinBreakpoin = _ref.pushMinBreakpoint,
    pushMinBreakpoint = _ref$pushMinBreakpoin === void 0 ? 'l' : _ref$pushMinBreakpoin,
    _ref$focusTrapProps = _ref.focusTrapProps,
    _focusTrapProps = _ref$focusTrapProps === void 0 ? {} : _ref$focusTrapProps,
    _ref$includeFixedHead = _ref.includeFixedHeadersInFocusTrap,
    includeFixedHeadersInFocusTrap = _ref$includeFixedHead === void 0 ? true : _ref$includeFixedHead,
    rest = _objectWithoutProperties(_ref, _excluded);
  var Element = as || defaultElement;
  var maskRef = (0, _react.useRef)(null);
  var windowIsLargeEnoughToPush = (0, _services.useIsWithinMinBreakpoint)(pushMinBreakpoint);
  var isPushed = type === 'push' && windowIsLargeEnoughToPush;

  /**
   * Setting up the refs on the actual flyout element in order to
   * accommodate for the `isPushed` state by adding padding to the body equal to the width of the element
   */
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    resizeRef = _useState2[0],
    setResizeRef = _useState2[1];
  var setRef = (0, _services.useCombinedRefs)([setResizeRef, ref]);
  // TODO: Allow this hook to be conditional
  var dimensions = (0, _resize_observer.useResizeObserver)(resizeRef);
  (0, _react.useEffect)(function () {
    // This class doesn't actually do anything by EUI, but is nice to add for consumers (JIC)
    document.body.classList.add('euiBody--hasFlyout');

    /**
     * Accomodate for the `isPushed` state by adding padding to the body equal to the width of the element
     */
    if (type === 'push') {
      if (isPushed) {
        if (side === 'right') {
          document.body.style.paddingRight = "".concat(dimensions.width, "px");
        } else if (side === 'left') {
          document.body.style.paddingLeft = "".concat(dimensions.width, "px");
        }
      }
    }
    return function () {
      document.body.classList.remove('euiBody--hasFlyout');
      if (type === 'push') {
        if (side === 'right') {
          document.body.style.paddingRight = '';
        } else if (side === 'left') {
          document.body.style.paddingLeft = '';
        }
      }
    };
  }, [type, side, dimensions, isPushed]);

  /**
   * ESC key closes flyout (always?)
   */
  var onKeyDown = function onKeyDown(event) {
    if (!isPushed && event.key === _services.keys.ESCAPE) {
      event.preventDefault();
      onClose(event);
    }
  };

  /**
   * Set inline styles
   */
  var newStyle = style;
  if (typeof maxWidth !== 'boolean') {
    newStyle = _objectSpread(_objectSpread({}, newStyle), (0, _global_styling.logicalStyle)('max-width', maxWidth));
  }
  if (!isEuiFlyoutSizeNamed(size)) {
    newStyle = _objectSpread(_objectSpread({}, newStyle), (0, _global_styling.logicalStyle)('width', size));
  }
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _flyout.euiFlyoutStyles)(euiTheme);
  var cssStyles = [styles.euiFlyout, styles.paddingSizes[paddingSize], isEuiFlyoutSizeNamed(size) && styles[size], maxWidth === false && styles.noMaxWidth, styles[type], type === 'push' && styles.pushSide[side], styles[side]];
  var classes = (0, _classnames.default)('euiFlyout', className);
  var closeButton;
  if (onClose && !hideCloseButton) {
    var closeButtonClasses = (0, _classnames.default)('euiFlyout__closeButton', closeButtonProps === null || closeButtonProps === void 0 ? void 0 : closeButtonProps.className);
    var closeButtonStyles = (0, _flyout.euiFlyoutCloseButtonStyles)(euiTheme);
    var closeButtonCssStyles = [closeButtonStyles.euiFlyout__closeButton, closeButtonStyles[closeButtonPosition], closeButtonPosition === 'outside' && closeButtonStyles.outsideSide[side]];
    closeButton = (0, _react2.jsx)(_i18n.EuiI18n, {
      token: "euiFlyout.closeAriaLabel",
      default: "Close this dialog"
    }, function (closeAriaLabel) {
      return (0, _react2.jsx)(_button.EuiButtonIcon, _extends({
        css: closeButtonCssStyles,
        display: closeButtonPosition === 'outside' ? 'fill' : 'empty',
        iconType: "cross",
        color: "text",
        "aria-label": closeAriaLabel,
        "data-test-subj": "euiFlyoutCloseButton"
      }, closeButtonProps, {
        className: closeButtonClasses,
        onClick: function onClick(e) {
          var _closeButtonProps$onC;
          onClose(e.nativeEvent);
          closeButtonProps === null || closeButtonProps === void 0 ? void 0 : (_closeButtonProps$onC = closeButtonProps.onClick) === null || _closeButtonProps$onC === void 0 ? void 0 : _closeButtonProps$onC.call(closeButtonProps, e);
        }
      }));
    });
  }

  /*
   * If not disabled, automatically add fixed EuiHeaders as shards
   * to EuiFlyout focus traps, to prevent focus fighting
   */
  var flyoutToggle = (0, _react.useRef)(document.activeElement);
  var _useState3 = (0, _react.useState)([]),
    _useState4 = _slicedToArray(_useState3, 2),
    fixedHeaders = _useState4[0],
    setFixedHeaders = _useState4[1];
  (0, _react.useEffect)(function () {
    if (includeFixedHeadersInFocusTrap) {
      var fixedHeaderEls = document.querySelectorAll('.euiHeader[data-fixed-header]');
      setFixedHeaders(Array.from(fixedHeaderEls));

      // Flyouts that are toggled from fixed headers do not have working
      // focus trap autoFocus, so we need to focus the flyout wrapper ourselves
      fixedHeaderEls.forEach(function (header) {
        if (header.contains(flyoutToggle.current)) {
          resizeRef === null || resizeRef === void 0 ? void 0 : resizeRef.focus();
        }
      });
    } else {
      // Clear existing headers if necessary, e.g. switching to `false`
      setFixedHeaders(function (headers) {
        return headers.length ? [] : headers;
      });
    }
  }, [includeFixedHeadersInFocusTrap, resizeRef]);
  var focusTrapProps = _objectSpread(_objectSpread({}, _focusTrapProps), {}, {
    shards: [].concat(_toConsumableArray(fixedHeaders), _toConsumableArray(_focusTrapProps.shards || []))
  });

  /*
   * Provide meaningful screen reader instructions/details
   */
  var hasOverlayMask = ownFocus && !isPushed;
  var descriptionId = (0, _services.useGeneratedHtmlId)();
  var screenReaderDescription = (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
    id: descriptionId
  }, hasOverlayMask ? (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiFlyout.screenReaderModalDialog",
    default: "You are in a modal dialog. Press Escape or tap/click outside the dialog on the shadowed overlay to close."
  }) : (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiFlyout.screenReaderNonModalDialog",
    default: "You are in a non-modal dialog. To close the dialog, press Escape."
  }), ' ', fixedHeaders.length > 0 && (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiFlyout.screenReaderFixedHeaders",
    default: "You can still continue tabbing through the page headers in addition to the dialog."
  })));

  /*
   * Trap focus even when `ownFocus={false}`, otherwise closing
   * the flyout won't return focus to the originating button.
   *
   * Set `clickOutsideDisables={true}` when `ownFocus={false}`
   * to allow non-keyboard users the ability to interact with
   * elements outside the flyout.
   *
   * Set `onClickOutside={onClose}` when `ownFocus` and `type` are the defaults,
   * or if `outsideClickCloses={true}` to close on clicks that target
   * (both mousedown and mouseup) the overlay mask.
   */
  var onClickOutside = function onClickOutside(event) {
    // Do not close the flyout for any external click
    if (outsideClickCloses === false) return undefined;
    if (hasOverlayMask) {
      // The overlay mask is present, so only clicks on the mask should close the flyout, regardless of outsideClickCloses
      if (event.target === maskRef.current) return onClose(event);
    } else {
      // No overlay mask is present, so any outside clicks should close the flyout
      if (outsideClickCloses === true) return onClose(event);
    }
    // Otherwise if ownFocus is false and outsideClickCloses is undefined, outside clicks should not close the flyout
    return undefined;
  };
  var flyout = (0, _react2.jsx)(_focus_trap.EuiFocusTrap, _extends({
    disabled: isPushed,
    scrollLock: hasOverlayMask,
    clickOutsideDisables: !ownFocus,
    onClickOutside: onClickOutside
  }, focusTrapProps), (0, _react2.jsx)(Element, _extends({
    css: cssStyles
  }, rest, {
    role: "dialog",
    className: classes,
    tabIndex: 0,
    "data-autofocus": true,
    "aria-describedby": !isPushed ? descriptionId : undefined,
    style: newStyle,
    ref: setRef
  }), !isPushed && screenReaderDescription, closeButton, children));

  // If ownFocus is set, wrap with an overlay and allow the user to click it to close it.
  var mergedMaskProps = _objectSpread(_objectSpread({}, maskProps), {}, {
    maskRef: (0, _services.useCombinedRefs)([maskProps === null || maskProps === void 0 ? void 0 : maskProps.maskRef, maskRef])
  });
  if (hasOverlayMask) {
    flyout = (0, _react2.jsx)(_overlay_mask.EuiOverlayMask, _extends({
      headerZindexLocation: "below"
    }, mergedMaskProps), flyout);
  } else if (!isPushed) {
    // Otherwise still wrap within an EuiPortal so it appends (unless it is the push style)
    flyout = (0, _react2.jsx)(_portal.EuiPortal, null, flyout);
  }
  return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_services.EuiWindowEvent, {
    event: "keydown",
    handler: onKeyDown
  }), flyout);
}
// React.forwardRef interferes with the inferred element type
// Casting to ensure correct element prop type checking for `as`
// e.g., `href` is not on a `div`
);
// Recast to allow `displayName`
exports.EuiFlyout = EuiFlyout;
EuiFlyout.displayName = 'EuiFlyout';