"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALID_GROW_VALUES = exports.EuiFlexItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _flex_item = require("./flex_item.styles");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "grow", "component"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiFlexItem = function EuiFlexItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    _ref$component = _ref.component,
    Component = _ref$component === void 0 ? 'div' : _ref$component,
    rest = _objectWithoutProperties(_ref, _excluded);
  validateGrowValue(grow);
  var styles = (0, _flex_item.euiFlexItemStyles)();
  var cssStyles = [styles.euiFlexItem, !grow ? styles.growZero : styles.grow, grow && (typeof grow === 'number' ? styles.growSizes[grow] : styles.growSizes['1'])];
  var classes = (0, _classnames.default)('euiFlexItem', className);
  return (0, _react2.jsx)(Component, _extends({
    css: cssStyles,
    className: classes
  }, rest), children);
};
exports.EuiFlexItem = EuiFlexItem;
EuiFlexItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  grow: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf([0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, null])]),
  // Leave this as an inline string enum so the props table properly parses it
  /**
     * @default div
     */
  component: _propTypes.default.any
};
var VALID_GROW_VALUES = [null, undefined, true, false, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
exports.VALID_GROW_VALUES = VALID_GROW_VALUES;
function validateGrowValue(value) {
  if (VALID_GROW_VALUES.indexOf(value) === -1) {
    throw new Error("Prop `grow` passed to `EuiFlexItem` must be a boolean or an integer between 0 and 10, received `".concat(value, "`"));
  }
}