"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var _react = _interopRequireWildcard(require("react"));
var _expression = require("./expression");
var _form = require("../form");
var _flex = require("../flex");
var _panel = require("../panel");
var _popover = require("../popover");
var _services = require("../../services");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
describe('EuiExpression', function () {
  var BaseExpression = function BaseExpression() {
    var _useState = (0, _react.useState)({
        isOpen: false,
        value: 'count()'
      }),
      _useState2 = _slicedToArray(_useState, 2),
      example1 = _useState2[0],
      setExample1 = _useState2[1];
    var _useState3 = (0, _react.useState)({
        value: 100,
        description: 'Is above'
      }),
      _useState4 = _slicedToArray(_useState3, 2),
      example2 = _useState4[0],
      setExample2 = _useState4[1];
    var expressionPopoverId__1 = (0, _services.useGeneratedHtmlId)({
      prefix: 'expressionPopover',
      suffix: 'first'
    });
    var expressionPopoverId__2 = (0, _services.useGeneratedHtmlId)({
      prefix: 'expressionPopover',
      suffix: 'second'
    });
    var openExample1 = function openExample1() {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        isOpen: true
      }));
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        isOpen: false
      }));
    };
    var closeExample1 = function closeExample1() {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        isOpen: false
      }));
    };
    var openExample2 = function openExample2() {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        isOpen: false
      }));
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        isOpen: true
      }));
    };
    var closeExample2 = function closeExample2() {
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        isOpen: false
      }));
    };
    var changeExample1 = function changeExample1(event) {
      setExample1(_objectSpread(_objectSpread({}, example1), {}, {
        value: event.target.value
      }));
    };
    var changeExample2Value = function changeExample2Value(e) {
      var sanitizedValue = parseInt(e.target.value, 10);
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        value: isNaN(sanitizedValue) ? '' : sanitizedValue
      }));
    };
    var changeExample2Description = function changeExample2Description(event) {
      setExample2(_objectSpread(_objectSpread({}, example2), {}, {
        description: event.target.value
      }));
    };
    var renderPopover1 = function renderPopover1() {
      return (0, _react2.jsx)("div", {
        "data-test-subj": "cy-expression-popover-1"
      }, (0, _react2.jsx)(_popover.EuiPopoverTitle, null, "When"), (0, _react2.jsx)(_form.EuiSelect, {
        compressed: true,
        value: example1.value,
        onChange: changeExample1,
        options: [{
          value: 'count()',
          text: 'count()'
        }, {
          value: 'average()',
          text: 'average()'
        }, {
          value: 'sum()',
          text: 'sum()'
        }, {
          value: 'median()',
          text: 'median()'
        }, {
          value: 'min()',
          text: 'min()'
        }, {
          value: 'max()',
          text: 'max()'
        }]
      }));
    };
    var renderPopover2 = function renderPopover2() {
      return (0, _react2.jsx)("div", {
        "data-test-subj": "cy-expression-popover-2"
      }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
        gutterSize: "s"
      }, (0, _react2.jsx)(_flex.EuiFlexItem, {
        grow: false,
        style: {
          width: 150
        }
      }, (0, _react2.jsx)(_form.EuiSelect, {
        compressed: true,
        value: example2.description,
        onChange: changeExample2Description,
        options: [{
          value: 'Is above',
          text: 'Is above'
        }, {
          value: 'Is below',
          text: 'Is below'
        }, {
          value: 'Is exactly',
          text: 'Is exactly'
        }]
      })), (0, _react2.jsx)(_flex.EuiFlexItem, {
        grow: false,
        style: {
          width: 100
        }
      }, (0, _react2.jsx)(_form.EuiFieldNumber, {
        compressed: true,
        value: example2.value,
        onChange: changeExample2Value
      }))));
    };
    return (0, _react2.jsx)(_panel.EuiPanel, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
      gutterSize: "s"
    }, (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_popover.EuiPopover, {
      id: expressionPopoverId__1,
      button: (0, _react2.jsx)(_expression.EuiExpression, {
        description: "when",
        value: example1.value,
        isActive: example1.isOpen,
        onClick: openExample1
      }),
      isOpen: example1.isOpen,
      closePopover: closeExample1,
      panelPaddingSize: "s",
      anchorPosition: "downLeft"
    }, renderPopover1())), (0, _react2.jsx)(_flex.EuiFlexItem, {
      grow: false
    }, (0, _react2.jsx)(_popover.EuiPopover, {
      id: expressionPopoverId__2,
      panelPaddingSize: "s",
      button: (0, _react2.jsx)(_expression.EuiExpression, {
        description: example2.description,
        value: example2.value,
        isActive: example2.isOpen,
        onClick: openExample2
      }),
      isOpen: example2.isOpen,
      closePopover: closeExample2,
      anchorPosition: "downLeft"
    }, renderPopover2()))));
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount((0, _react2.jsx)(BaseExpression, null));
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when count popover is open', function () {
      cy.get('button').contains(/When count\(\)/i).realClick();
      cy.get('div[data-test-subj="cy-expression-popover-1"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when is above popover is open', function () {
      cy.get('button').contains(/Is above 100/i).realClick();
      cy.get('div[data-test-subj="cy-expression-popover-2"]').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when first popover is interacted with by keyboard', function () {
      cy.realPress('Tab');
      cy.get('button').contains(/When count\(\)/i).should('have.focus');
      cy.realPress('Enter');
      cy.get('div[data-test-subj="cy-expression-popover-1"]').should('exist');
      cy.realPress('Tab');
      cy.realPress(['a', 'v', 'g']);
      cy.realPress('Escape');
      cy.get('button').contains(/When average\(\)/i).should('have.focus');
      cy.checkAxe();
    });
    it('has zero violations when second popover is interacted with by keyboard', function () {
      cy.repeatRealPress('Tab');
      cy.get('button').contains(/Is above 100/i).should('have.focus');
      cy.realPress('Enter');
      cy.get('div[data-test-subj="cy-expression-popover-2"]').should('exist');
      cy.realPress('Tab');
      cy.realPress(['I', 's', ' ', 'e']);
      cy.realPress('Tab');
      cy.repeatRealPress('Delete', 3);
      cy.realPress(['5', '0', '0']);
      cy.realPress('Escape');
      cy.get('button').contains(/Is exactly 500/i).should('have.focus');
      cy.checkAxe();
    });
  });
});