"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiErrorBoundaryStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiErrorBoundaryStyles = function euiErrorBoundaryStyles(_ref) {
  var euiTheme = _ref.euiTheme;
  var color1 = (0, _services.transparentize)(euiTheme.colors.danger, 0.25);
  var color2 = (0, _services.transparentize)(euiTheme.colors.danger, 0.05);
  return {
    euiErrorBoundary: /*#__PURE__*/(0, _react.css)("background-image:repeating-linear-gradient(\n        45deg,\n        ", color1, ",\n        ", color1, " 1px,\n        ", color2, " 1px,\n        ", color2, " 19px\n      );background-size:54px 54px;", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.base), ";", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.base), ";;label:euiErrorBoundary;")
  };
};
exports.euiErrorBoundaryStyles = euiErrorBoundaryStyles;