"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useI18nTimeOptions = exports.RenderI18nTimeOptions = exports.NEXT = exports.LAST = void 0;
var _i18n = require("../../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var LAST = 'last';
exports.LAST = LAST;
var NEXT = 'next';
exports.NEXT = NEXT;
/**
 * i18n'd time options, mostly used in EuiSelects (except for a few cases)
 * used in EuiSuperDatePicker child sub-components
 */
var useI18nTimeOptions = function useI18nTimeOptions() {
  /**
   * Quick select panel
   */
  var timeTenseOptions = [{
    value: LAST,
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.last', 'Last')
  }, {
    value: NEXT,
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.next', 'Next')
  }];
  var timeUnitsOptions = [{
    value: 's',
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.seconds', 'Seconds')
  }, {
    value: 'm',
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.minutes', 'Minutes')
  }, {
    value: 'h',
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.hours', 'Hours')
  }, {
    value: 'd',
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.days', 'Days')
  }, {
    value: 'w',
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.weeks', 'Weeks')
  }, {
    value: 'M',
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.months', 'Months')
  }, {
    value: 'y',
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.years', 'Years')
  }];

  /**
   * Relative tab
   */
  var relativeOptions = [{
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.secondsAgo', 'Seconds ago'),
    value: 's'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.minutesAgo', 'Minutes ago'),
    value: 'm'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.hoursAgo', 'Hours ago'),
    value: 'h'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.daysAgo', 'Days ago'),
    value: 'd'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.weeksAgo', 'Weeks ago'),
    value: 'w'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.monthsAgo', 'Months ago'),
    value: 'M'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.yearsAgo', 'Years ago'),
    value: 'y'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.secondsFromNow', 'Seconds from now'),
    value: 's+'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.minutesFromNow', 'Minutes from now'),
    value: 'm+'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.hoursFromNow', 'Hours from now'),
    value: 'h+'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.daysFromNow', 'Days from now'),
    value: 'd+'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.weeksFromNow', 'Weeks from now'),
    value: 'w+'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.monthsFromNow', 'Months from now'),
    value: 'M+'
  }, {
    text: (0, _i18n.useEuiI18n)('euiTimeOptions.yearsFromNow', 'Years from now'),
    value: 'y+'
  }];
  var relativeRoundingLabels = {
    s: (0, _i18n.useEuiI18n)('euiTimeOptions.roundToSecond', 'Round to the second'),
    m: (0, _i18n.useEuiI18n)('euiTimeOptions.roundToMinute', 'Round to the minute'),
    h: (0, _i18n.useEuiI18n)('euiTimeOptions.roundToHour', 'Round to the hour'),
    d: (0, _i18n.useEuiI18n)('euiTimeOptions.roundToDay', 'Round to the day'),
    w: (0, _i18n.useEuiI18n)('euiTimeOptions.roundToWeek', 'Round to the week'),
    M: (0, _i18n.useEuiI18n)('euiTimeOptions.roundToMonth', 'Round to the month'),
    y: (0, _i18n.useEuiI18n)('euiTimeOptions.roundToYear', 'Round to the year')
  };

  /**
   * Auto Refresh
   */
  var refreshUnitsOptions = timeUnitsOptions.filter(function (_ref) {
    var value = _ref.value;
    return value === 'h' || value === 'm' || value === 's';
  });

  /**
   * Used by both Quick Select ('Commonly used') and by PrettyDuration
   */
  var commonDurationRanges = [{
    start: 'now/d',
    end: 'now/d',
    label: (0, _i18n.useEuiI18n)('euiTimeOptions.today', 'Today')
  }, {
    start: 'now/w',
    end: 'now/w',
    label: (0, _i18n.useEuiI18n)('euiTimeOptions.thisWeek', 'This week')
  }, {
    start: 'now/M',
    end: 'now/M',
    label: (0, _i18n.useEuiI18n)('euiTimeOptions.thisMonth', 'This month')
  }, {
    start: 'now/y',
    end: 'now/y',
    label: (0, _i18n.useEuiI18n)('euiTimeOptions.thisYear', 'This year')
  }, {
    start: 'now-1d/d',
    end: 'now-1d/d',
    label: (0, _i18n.useEuiI18n)('euiTimeOptions.yesterday', 'Yesterday')
  }, {
    start: 'now/w',
    end: 'now',
    label: (0, _i18n.useEuiI18n)('euiTimeOptions.weekToDate', 'Week to date')
  }, {
    start: 'now/M',
    end: 'now',
    label: (0, _i18n.useEuiI18n)('euiTimeOptions.monthToDate', 'Month to date')
  }, {
    start: 'now/y',
    end: 'now',
    label: (0, _i18n.useEuiI18n)('euiTimeOptions.yearToDate', 'Year to date')
  }];
  return {
    timeTenseOptions: timeTenseOptions,
    timeUnitsOptions: timeUnitsOptions,
    relativeOptions: relativeOptions,
    relativeRoundingLabels: relativeRoundingLabels,
    refreshUnitsOptions: refreshUnitsOptions,
    commonDurationRanges: commonDurationRanges
  };
};

// Render function of the above, used by class components that can't use hooks
exports.useI18nTimeOptions = useI18nTimeOptions;
var RenderI18nTimeOptions = function RenderI18nTimeOptions(props) {
  var timeOptions = useI18nTimeOptions();
  return props.children(timeOptions);
};
exports.RenderI18nTimeOptions = RenderI18nTimeOptions;