"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrettyInterval = void 0;
var _i18n = require("../../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var MS_IN_SECOND = 1000;
var MS_IN_MINUTE = 60 * MS_IN_SECOND;
var MS_IN_HOUR = 60 * MS_IN_MINUTE;
var MS_IN_DAY = 24 * MS_IN_HOUR;
/**
 * Pretty interval i18n strings
 *
 * Units should not be simply concatenated because different languages
 * will have different grammar/positions for time than English
 */
var usePrettyIntervalI18n = function usePrettyIntervalI18n(interval) {
  return {
    s: (0, _i18n.useEuiI18n)('euiPrettyInterval.seconds', function (_ref) {
      var interval = _ref.interval;
      return "".concat(interval, " second").concat(interval > 1 ? 's' : '');
    }, {
      interval: interval
    }),
    m: (0, _i18n.useEuiI18n)('euiPrettyInterval.minutes', function (_ref2) {
      var interval = _ref2.interval;
      return "".concat(interval, " minute").concat(interval > 1 ? 's' : '');
    }, {
      interval: interval
    }),
    h: (0, _i18n.useEuiI18n)('euiPrettyInterval.hours', function (_ref3) {
      var interval = _ref3.interval;
      return "".concat(interval, " hour").concat(interval > 1 ? 's' : '');
    }, {
      interval: interval
    }),
    d: (0, _i18n.useEuiI18n)('euiPrettyInterval.days', function (_ref4) {
      var interval = _ref4.interval;
      return "".concat(interval, " day").concat(interval > 1 ? 's' : '');
    }, {
      interval: interval
    }),
    shorthand: {
      s: (0, _i18n.useEuiI18n)('euiPrettyInterval.secondsShorthand', '{interval} s', {
        interval: interval
      }),
      m: (0, _i18n.useEuiI18n)('euiPrettyInterval.minutesShorthand', '{interval} m', {
        interval: interval
      }),
      h: (0, _i18n.useEuiI18n)('euiPrettyInterval.hoursShorthand', '{interval} h', {
        interval: interval
      }),
      d: (0, _i18n.useEuiI18n)('euiPrettyInterval.daysShorthand', '{interval} d', {
        interval: interval
      })
    }
  };
};
var usePrettyInterval = function usePrettyInterval(isPaused, intervalInMs) {
  var shortHand = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var prettyInterval = '';
  var interval;
  var unitId;
  if (intervalInMs < MS_IN_MINUTE) {
    interval = Math.round(intervalInMs / MS_IN_SECOND);
    unitId = 's';
  } else if (intervalInMs < MS_IN_HOUR) {
    interval = Math.round(intervalInMs / MS_IN_MINUTE);
    unitId = 'm';
  } else if (intervalInMs < MS_IN_DAY) {
    interval = Math.round(intervalInMs / MS_IN_HOUR);
    unitId = 'h';
  } else {
    interval = Math.round(intervalInMs / MS_IN_DAY);
    unitId = 'd';
  }
  var prettyIntervalI18n = usePrettyIntervalI18n(interval);
  prettyInterval = shortHand ? prettyIntervalI18n.shorthand[unitId] : prettyIntervalI18n[unitId];
  var off = (0, _i18n.useEuiI18n)('euiPrettyInterval.off', 'Off');
  if (isPaused || intervalInMs === 0) {
    prettyInterval = off;
  }
  return prettyInterval;
};
exports.usePrettyInterval = usePrettyInterval;