"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _date_utils = require("./date_utils");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var Day = /*#__PURE__*/function (_React$Component) {
  _inherits(Day, _React$Component);
  var _super = _createSuper(Day);
  function Day() {
    var _this;
    _classCallCheck(this, Day);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "handleClick", function (event) {
      if (!_this.isDisabled() && _this.props.onClick) {
        _this.props.onClick(event);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "handleMouseEnter", function (event) {
      if (!_this.isDisabled() && _this.props.onMouseEnter) {
        _this.props.onMouseEnter(event);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "isSameDay", function (other) {
      return (0, _date_utils.isSameDay)(_this.props.day, other);
    });
    _defineProperty(_assertThisInitialized(_this), "isKeyboardSelected", function () {
      return !_this.props.disabledKeyboardNavigation && (!_this.props.inline || _this.props.accessibleMode) && !_this.isSameDay(_this.props.selected) && _this.isSameDay(_this.props.preSelection);
    });
    _defineProperty(_assertThisInitialized(_this), "isDisabled", function () {
      return (0, _date_utils.isDayDisabled)(_this.props.day, _this.props);
    });
    _defineProperty(_assertThisInitialized(_this), "getHighLightedClass", function (defaultClassName) {
      var _this$props = _this.props,
        day = _this$props.day,
        highlightDates = _this$props.highlightDates;
      if (!highlightDates) {
        return false;
      }

      // Looking for className in the Map of {'day string, 'className'}
      var dayStr = day.format("MM.DD.YYYY");
      return highlightDates.get(dayStr);
    });
    _defineProperty(_assertThisInitialized(_this), "isInRange", function () {
      var _this$props2 = _this.props,
        day = _this$props2.day,
        startDate = _this$props2.startDate,
        endDate = _this$props2.endDate;
      if (!startDate || !endDate) {
        return false;
      }
      return (0, _date_utils.isDayInRange)(day, startDate, endDate);
    });
    _defineProperty(_assertThisInitialized(_this), "isInSelectingRange", function () {
      var _this$props3 = _this.props,
        day = _this$props3.day,
        selectsStart = _this$props3.selectsStart,
        selectsEnd = _this$props3.selectsEnd,
        selectingDate = _this$props3.selectingDate,
        startDate = _this$props3.startDate,
        endDate = _this$props3.endDate;
      if (!(selectsStart || selectsEnd) || !selectingDate || _this.isDisabled()) {
        return false;
      }
      if (selectsStart && endDate && selectingDate.isSameOrBefore(endDate)) {
        return (0, _date_utils.isDayInRange)(day, selectingDate, endDate);
      }
      if (selectsEnd && startDate && selectingDate.isSameOrAfter(startDate)) {
        return (0, _date_utils.isDayInRange)(day, startDate, selectingDate);
      }
      return false;
    });
    _defineProperty(_assertThisInitialized(_this), "isSelectingRangeStart", function () {
      if (!_this.isInSelectingRange()) {
        return false;
      }
      var _this$props4 = _this.props,
        day = _this$props4.day,
        selectingDate = _this$props4.selectingDate,
        startDate = _this$props4.startDate,
        selectsStart = _this$props4.selectsStart;
      if (selectsStart) {
        return (0, _date_utils.isSameDay)(day, selectingDate);
      } else {
        return (0, _date_utils.isSameDay)(day, startDate);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "isSelectingRangeEnd", function () {
      if (!_this.isInSelectingRange()) {
        return false;
      }
      var _this$props5 = _this.props,
        day = _this$props5.day,
        selectingDate = _this$props5.selectingDate,
        endDate = _this$props5.endDate,
        selectsEnd = _this$props5.selectsEnd;
      if (selectsEnd) {
        return (0, _date_utils.isSameDay)(day, selectingDate);
      } else {
        return (0, _date_utils.isSameDay)(day, endDate);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "isRangeStart", function () {
      var _this$props6 = _this.props,
        day = _this$props6.day,
        startDate = _this$props6.startDate,
        endDate = _this$props6.endDate;
      if (!startDate || !endDate) {
        return false;
      }
      return (0, _date_utils.isSameDay)(startDate, day);
    });
    _defineProperty(_assertThisInitialized(_this), "isRangeEnd", function () {
      var _this$props7 = _this.props,
        day = _this$props7.day,
        startDate = _this$props7.startDate,
        endDate = _this$props7.endDate;
      if (!startDate || !endDate) {
        return false;
      }
      return (0, _date_utils.isSameDay)(endDate, day);
    });
    _defineProperty(_assertThisInitialized(_this), "isWeekend", function () {
      var weekday = (0, _date_utils.getDay)(_this.props.day);
      return weekday === 0 || weekday === 6;
    });
    _defineProperty(_assertThisInitialized(_this), "isOutsideMonth", function () {
      return _this.props.month !== undefined && _this.props.month !== (0, _date_utils.getMonth)(_this.props.day);
    });
    _defineProperty(_assertThisInitialized(_this), "getClassNames", function (date) {
      var dayClassName = _this.props.dayClassName ? _this.props.dayClassName(date) : undefined;
      return (0, _classnames.default)("react-datepicker__day", dayClassName, "react-datepicker__day--" + (0, _date_utils.getDayOfWeekCode)(_this.props.day), {
        "react-datepicker__day--disabled": _this.isDisabled(),
        "react-datepicker__day--selected": _this.isSameDay(_this.props.selected),
        "react-datepicker__day--keyboard-selected": _this.isKeyboardSelected(),
        "react-datepicker__day--range-start": _this.isRangeStart(),
        "react-datepicker__day--range-end": _this.isRangeEnd(),
        "react-datepicker__day--in-range": _this.isInRange(),
        "react-datepicker__day--in-selecting-range": _this.isInSelectingRange(),
        "react-datepicker__day--selecting-range-start": _this.isSelectingRangeStart(),
        "react-datepicker__day--selecting-range-end": _this.isSelectingRangeEnd(),
        "react-datepicker__day--today": _this.isSameDay((0, _date_utils.now)(_this.props.utcOffset)),
        "react-datepicker__day--weekend": _this.isWeekend(),
        "react-datepicker__day--outside-month": _this.isOutsideMonth()
      }, _this.getHighLightedClass("react-datepicker__day--highlighted"));
    });
    return _this;
  }
  _createClass(Day, [{
    key: "render",
    value: function render() {
      return (0, _react2.jsx)("div", {
        className: this.getClassNames(this.props.day),
        onClick: this.handleClick,
        onMouseEnter: this.handleMouseEnter,
        "aria-label": "day-".concat((0, _date_utils.getDate)(this.props.day)),
        role: "option"
      }, this.props.renderDayContents ? this.props.renderDayContents((0, _date_utils.getDate)(this.props.day)) : (0, _date_utils.getDate)(this.props.day));
    }
  }]);
  return Day;
}(_react.default.Component);
exports.default = Day;
_defineProperty(Day, "propTypes", {
  disabledKeyboardNavigation: _propTypes.default.bool,
  day: _propTypes.default.object.isRequired,
  dayClassName: _propTypes.default.func,
  endDate: _propTypes.default.object,
  highlightDates: _propTypes.default.instanceOf(Map),
  inline: _propTypes.default.bool,
  month: _propTypes.default.number,
  onClick: _propTypes.default.func,
  onMouseEnter: _propTypes.default.func,
  preSelection: _propTypes.default.object,
  selected: _propTypes.default.object,
  selectingDate: _propTypes.default.object,
  selectsEnd: _propTypes.default.bool,
  selectsStart: _propTypes.default.bool,
  startDate: _propTypes.default.object,
  utcOffset: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
  renderDayContents: _propTypes.default.func,
  accessibleMode: _propTypes.default.bool
});
module.exports = exports.default;