"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiDatePickerRange = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _icon = require("../icon");
var _react2 = require("@emotion/react");
var _excluded = ["children", "className", "startDateControl", "endDateControl", "iconType", "fullWidth", "isCustom", "readOnly", "isInvalid", "disabled", "onFocus", "onBlur"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiDatePickerRange = function EuiDatePickerRange(_ref) {
  var children = _ref.children,
    className = _ref.className,
    startDateControl = _ref.startDateControl,
    endDateControl = _ref.endDateControl,
    _ref$iconType = _ref.iconType,
    iconType = _ref$iconType === void 0 ? true : _ref$iconType,
    fullWidth = _ref.fullWidth,
    isCustom = _ref.isCustom,
    readOnly = _ref.readOnly,
    isInvalid = _ref.isInvalid,
    disabled = _ref.disabled,
    _onFocus = _ref.onFocus,
    _onBlur = _ref.onBlur,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = (0, _classnames.default)('euiDatePickerRange', {
    'euiDatePickerRange--fullWidth': fullWidth,
    'euiDatePickerRange--readOnly': readOnly,
    'euiDatePickerRange--isInvalid': isInvalid,
    'euiDatePickerRange--isDisabled': disabled
  }, className);
  var startControl = startDateControl;
  var endControl = endDateControl;
  if (!isCustom) {
    startControl = /*#__PURE__*/(0, _react.cloneElement)(startDateControl, {
      iconType: typeof iconType === 'boolean' ? undefined : iconType,
      showIcon: !!iconType,
      fullWidth: fullWidth,
      readOnly: readOnly,
      disabled: disabled || startDateControl.props.disabled,
      isInvalid: isInvalid || startDateControl.props.isInvalid,
      className: (0, _classnames.default)('euiDatePickerRange__start', startDateControl.props.className),
      onBlur: function onBlur(event) {
        var _startDateControl$pro, _startDateControl$pro2;
        (_startDateControl$pro = startDateControl.props) === null || _startDateControl$pro === void 0 ? void 0 : (_startDateControl$pro2 = _startDateControl$pro.onBlur) === null || _startDateControl$pro2 === void 0 ? void 0 : _startDateControl$pro2.call(_startDateControl$pro, event);
        _onBlur === null || _onBlur === void 0 ? void 0 : _onBlur(event);
      },
      onFocus: function onFocus(event) {
        var _startDateControl$pro3, _startDateControl$pro4;
        (_startDateControl$pro3 = startDateControl.props) === null || _startDateControl$pro3 === void 0 ? void 0 : (_startDateControl$pro4 = _startDateControl$pro3.onFocus) === null || _startDateControl$pro4 === void 0 ? void 0 : _startDateControl$pro4.call(_startDateControl$pro3, event);
        _onFocus === null || _onFocus === void 0 ? void 0 : _onFocus(event);
      }
    });
    endControl = /*#__PURE__*/(0, _react.cloneElement)(endDateControl, {
      showIcon: false,
      fullWidth: fullWidth,
      readOnly: readOnly,
      disabled: disabled || endDateControl.props.disabled,
      isInvalid: isInvalid || endDateControl.props.isInvalid,
      popoverPlacement: 'downRight',
      className: (0, _classnames.default)('euiDatePickerRange__end', endDateControl.props.className),
      onBlur: function onBlur(event) {
        var _endDateControl$props, _endDateControl$props2;
        (_endDateControl$props = endDateControl.props) === null || _endDateControl$props === void 0 ? void 0 : (_endDateControl$props2 = _endDateControl$props.onBlur) === null || _endDateControl$props2 === void 0 ? void 0 : _endDateControl$props2.call(_endDateControl$props, event);
        _onBlur === null || _onBlur === void 0 ? void 0 : _onBlur(event);
      },
      onFocus: function onFocus(event) {
        var _endDateControl$props3, _endDateControl$props4;
        (_endDateControl$props3 = endDateControl.props) === null || _endDateControl$props3 === void 0 ? void 0 : (_endDateControl$props4 = _endDateControl$props3.onFocus) === null || _endDateControl$props4 === void 0 ? void 0 : _endDateControl$props4.call(_endDateControl$props3, event);
        _onFocus === null || _onFocus === void 0 ? void 0 : _onFocus(event);
      }
    });
  }
  var delimiter = (0, _react2.jsx)("span", {
    className: "euiDatePickerRange__delimeter"
  }, (0, _react2.jsx)(_icon.EuiIcon, {
    color: isInvalid ? 'danger' : 'subdued',
    type: "sortRight"
  }));
  return (0, _react2.jsx)("div", _extends({
    className: classes
  }, rest), children ? children : (0, _react2.jsx)(_react.Fragment, null, startControl, delimiter, endControl));
};
exports.EuiDatePickerRange = EuiDatePickerRange;
EuiDatePickerRange.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * Including any children will replace all innards with the provided children
     */
  children: _propTypes.default.node,
  /**
     * The end date `EuiDatePicker` element
     */
  endDateControl: _propTypes.default.element.isRequired,
  /**
     * The start date `EuiDatePicker` element
     */
  startDateControl: _propTypes.default.element.isRequired,
  /**
     * Pass either an icon type or set to `false` to remove icon entirely
     */
  iconType: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "check", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "error", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "namespace", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelionApp", "timeRefresh", "timeslider", "training", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "warning", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDenseVector", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]).isRequired]),
  /**
     * Won't apply any additional props to start and end date components
     */
  isCustom: _propTypes.default.bool,
  /**
     * Will color the range delimiter the `danger` color and pass through to each control
     */
  isInvalid: _propTypes.default.bool,
  /**
     * Passes through to each control
     */
  disabled: _propTypes.default.bool,
  /**
     * Passes through to each control
     */
  readOnly: _propTypes.default.bool,
  /**
     * Passes through to each control
     */
  fullWidth: _propTypes.default.bool,
  /**
     * Triggered whenever the start or end controls are blurred
     */
  onBlur: _propTypes.default.any,
  /**
     * Triggered whenever the start or end controls are focused
     */
  onFocus: _propTypes.default.any
};