"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScrollCellIntoView = exports.useScrollBars = exports.useScroll = void 0;
var _react = _interopRequireWildcard(require("react"));
var _data_grid_cell_popover = require("../body/data_grid_cell_popover");
var _focus = require("./focus");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, defineProperty = Object.defineProperty || function (obj, key, desc) { obj[key] = desc.value; }, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return defineProperty(generator, "_invoke", { value: makeInvokeMethod(innerFn, self, context) }), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; defineProperty(this, "_invoke", { value: function value(method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; } function maybeInvokeDelegate(delegate, context) { var methodName = context.method, method = delegate.iterator[methodName]; if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator.return && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel; var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), defineProperty(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (val) { var object = Object(val), keys = []; for (var key in object) keys.push(key); return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, catch: function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
/**
 * The primary goal of this scroll logic is to ensure keyboard navigation works accessibly,
 * but there are other scenarios where it applies (e.g. clicking partially-visible cells)
 * or is useful for (e.g. manually scrolling to cell that is currently out of viewport
 * while accounting for headers/footers/scrollbars)
 */
var useScroll = function useScroll(args) {
  var _useScrollCellIntoVie = useScrollCellIntoView(args),
    scrollCellIntoView = _useScrollCellIntoVie.scrollCellIntoView;
  var _useContext = (0, _react.useContext)(_focus.DataGridFocusContext),
    focusedCell = _useContext.focusedCell;
  (0, _react.useEffect)(function () {
    if (focusedCell) {
      scrollCellIntoView({
        rowIndex: focusedCell[1],
        colIndex: focusedCell[0]
      });
    }
  }, [focusedCell, scrollCellIntoView]);
  var _useContext2 = (0, _react.useContext)(_data_grid_cell_popover.DataGridCellPopoverContext),
    popoverIsOpen = _useContext2.popoverIsOpen,
    cellLocation = _useContext2.cellLocation;
  (0, _react.useEffect)(function () {
    if (popoverIsOpen) {
      scrollCellIntoView({
        rowIndex: cellLocation.rowIndex,
        colIndex: cellLocation.colIndex
      });
    }
  }, [popoverIsOpen, cellLocation, scrollCellIntoView]);
  return {
    scrollCellIntoView: scrollCellIntoView
  };
};

/**
 * Ensures that the passed cell is always fully in view by using cell position
 * checks and scroll adjustments/workarounds.
 */
exports.useScroll = useScroll;
var useScrollCellIntoView = function useScrollCellIntoView(_ref) {
  var gridRef = _ref.gridRef,
    outerGridRef = _ref.outerGridRef,
    hasGridScrolling = _ref.hasGridScrolling,
    headerRowHeight = _ref.headerRowHeight,
    footerRowHeight = _ref.footerRowHeight,
    visibleRowCount = _ref.visibleRowCount,
    hasStickyFooter = _ref.hasStickyFooter;
  var scrollCellIntoView = (0, _react.useCallback)(
  /*#__PURE__*/
  // Note: in order for this UX to work correctly with react-window's APIs,
  // the `rowIndex` arg expected is actually our internal `visibleRowIndex`,
  // not the `rowIndex` from the raw unsorted/unpaginated user data
  function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(_ref2) {
      var _adjustedScrollLeft;
      var rowIndex, colIndex, getCell, cell, cellIsInView, _outerGridRef$current, scrollTop, scrollLeft, adjustedScrollTop, adjustedScrollLeft, cellRightPos, rightScrollBound, rightWidthOutOfView, cellLeftPos, leftScrollBound, leftWidthOutOfView, isStickyHeader, isStickyFooter, _adjustedScrollTop, parentRow, cellBottomPos, bottomScrollBound, bottomHeightOutOfView, cellTopPos, topScrollBound, topHeightOutOfView, _adjustedScrollLeft2, _adjustedScrollTop2;
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            rowIndex = _ref2.rowIndex, colIndex = _ref2.colIndex;
            if (!(!gridRef.current || !outerGridRef.current)) {
              _context.next = 3;
              break;
            }
            return _context.abrupt("return");
          case 3:
            if (hasGridScrolling) {
              _context.next = 5;
              break;
            }
            return _context.abrupt("return");
          case 5:
            // Obtain the outermost wrapper of the current cell in view in order to
            // get scroll position/height/width calculations and determine what level
            // of scroll adjustment the cell needs
            getCell = function getCell() {
              return outerGridRef.current.querySelector("[data-gridcell-column-index=\"".concat(colIndex, "\"][data-gridcell-visible-row-index=\"").concat(rowIndex, "\"]"));
            };
            cell = getCell(); // If the cell is completely out of view, we need to use react-window's
            // scrollToItem API to get it virtualized and rendered.
            cellIsInView = !!getCell();
            if (cellIsInView) {
              _context.next = 13;
              break;
            }
            gridRef.current.scrollToItem({
              rowIndex: rowIndex,
              columnIndex: colIndex
            });
            _context.next = 12;
            return new Promise(requestAnimationFrame);
          case 12:
            // The cell does not immediately render - we need to wait an async tick
            cell = getCell();
          case 13:
            if (cell) {
              _context.next = 15;
              break;
            }
            return _context.abrupt("return");
          case 15:
            // If for some reason we can't find a valid cell, short-circuit
            // We now manually adjust scroll positioning around the cell to ensure it's
            // fully in view on all sides. A couple of notes on this:
            // 1. We're avoiding relying on react-window's scrollToItem for this because it also
            //    does not account for sticky items (see https://github.com/bvaughn/react-window/issues/586)
            // 2. The current scroll position we're using as a base comes from either by
            //    `scrollToItem` or native .focus()'s automatic scroll behavior. This gets us
            //    halfway there, but doesn't guarantee the *full* cell in view, or account for
            //    sticky positioned rows or OS scrollbars, hence these workarounds
            _outerGridRef$current = outerGridRef.current, scrollTop = _outerGridRef$current.scrollTop, scrollLeft = _outerGridRef$current.scrollLeft;
            // Check if the cell's right side is outside the current scrolling bounds
            cellRightPos = cell.offsetLeft + cell.offsetWidth;
            rightScrollBound = scrollLeft + outerGridRef.current.clientWidth; // Note: We specifically want clientWidth and not offsetWidth here to account for scrollbars
            rightWidthOutOfView = cellRightPos - rightScrollBound;
            if (rightWidthOutOfView > 0) {
              adjustedScrollLeft = scrollLeft + rightWidthOutOfView;
            }

            // Check if the cell's left side is outside the current scrolling bounds
            cellLeftPos = cell.offsetLeft;
            leftScrollBound = (_adjustedScrollLeft = adjustedScrollLeft) !== null && _adjustedScrollLeft !== void 0 ? _adjustedScrollLeft : scrollLeft;
            leftWidthOutOfView = leftScrollBound - cellLeftPos;
            if (leftWidthOutOfView > 0) {
              // Note: This overrides the right side being out of bounds, as we want to prefer
              // showing the top-left corner of items if a cell is larger than the grid container
              adjustedScrollLeft = cellLeftPos;
            }

            // Skip top/bottom scroll adjustments for sticky headers & footers
            // since they should always be in view vertically
            isStickyHeader = rowIndex === -1;
            isStickyFooter = hasStickyFooter && rowIndex === visibleRowCount;
            if (!isStickyHeader && !isStickyFooter) {
              parentRow = cell.parentNode; // Check if the cell's bottom side is outside the current scrolling bounds
              cellBottomPos = parentRow.offsetTop + cell.offsetHeight;
              bottomScrollBound = scrollTop + outerGridRef.current.clientHeight; // Note: We specifically want clientHeight and not offsetHeight here to account for scrollbars
              if (hasStickyFooter) bottomScrollBound -= footerRowHeight; // Sticky footer is not always present
              bottomHeightOutOfView = cellBottomPos - bottomScrollBound;
              if (bottomHeightOutOfView > 0) {
                adjustedScrollTop = scrollTop + bottomHeightOutOfView;
              }

              // Check if the cell's top side is outside the current scrolling bounds
              cellTopPos = parentRow.offsetTop;
              topScrollBound = (_adjustedScrollTop = adjustedScrollTop) !== null && _adjustedScrollTop !== void 0 ? _adjustedScrollTop : scrollTop + headerRowHeight; // Sticky header is always present
              topHeightOutOfView = topScrollBound - cellTopPos;
              if (topHeightOutOfView > 0) {
                // Note: This overrides the bottom side being out of bounds, as we want to prefer
                // showing the top-left corner of items if a cell is larger than the grid container
                adjustedScrollTop = cellTopPos - headerRowHeight;
              }
            }

            // Check for undefined specifically (because 0 is a valid scroll position)
            // to avoid unnecessarily calling scrollTo or hijacking scroll
            if (adjustedScrollTop !== undefined || adjustedScrollLeft !== undefined) {
              gridRef.current.scrollTo({
                scrollLeft: (_adjustedScrollLeft2 = adjustedScrollLeft) !== null && _adjustedScrollLeft2 !== void 0 ? _adjustedScrollLeft2 : scrollLeft,
                scrollTop: (_adjustedScrollTop2 = adjustedScrollTop) !== null && _adjustedScrollTop2 !== void 0 ? _adjustedScrollTop2 : scrollTop
              });
            }
          case 28:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function (_x) {
      return _ref3.apply(this, arguments);
    };
  }(), [gridRef, outerGridRef, hasGridScrolling, headerRowHeight, footerRowHeight, visibleRowCount, hasStickyFooter]);
  return {
    scrollCellIntoView: scrollCellIntoView
  };
};

/**
 * Checks whether the current grid scrolls and/or has scrollbars
 */
exports.useScrollCellIntoView = useScrollCellIntoView;
var useScrollBars = function useScrollBars(outerGridRef) {
  var borderStyle = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'all';
  // https://stackoverflow.com/a/40568748/4294462
  var scrollBarHeight = outerGridRef.current ? outerGridRef.current.offsetHeight - outerGridRef.current.clientHeight : 0;
  var scrollBarWidth = outerGridRef.current ? outerGridRef.current.offsetWidth - outerGridRef.current.clientWidth : 0;

  // https://stackoverflow.com/a/5038256
  // Note that it is possible (MacOS) for a grid to scroll but not have scrollbar widths/heights
  var hasHorizontalScroll = outerGridRef.current ? outerGridRef.current.scrollWidth > outerGridRef.current.clientWidth : false;
  var hasVerticalScroll = outerGridRef.current ? outerGridRef.current.scrollHeight > outerGridRef.current.clientHeight : false;

  // If the grid scrolls or has scrollbars, we add custom border overlays
  // (since borders are normally set by cells) to ensure our grid body has
  // ending borders regardless of scroll position
  var scrollBorderOverlay = (0, _react.useMemo)(function () {
    if (!hasHorizontalScroll && !hasVerticalScroll) {
      return null; // Nothing to render if the grid doesn't scroll
    }

    if (borderStyle === 'none') {
      return null; // Nothing to render if the grid doesn't use borders
    }

    return (0, _react2.jsx)("div", {
      className: "euiDataGrid__scrollOverlay",
      role: "presentation"
    }, scrollBarHeight > 0 && (0, _react2.jsx)("div", {
      className: "euiDataGrid__scrollBarOverlayBottom",
      style: {
        bottom: scrollBarHeight,
        right: 0
      }
    }), scrollBarWidth > 0 && (0, _react2.jsx)("div", {
      className: "euiDataGrid__scrollBarOverlayRight",
      style: {
        bottom: scrollBarHeight,
        right: scrollBarWidth
      }
    }));
  }, [hasHorizontalScroll, hasVerticalScroll, scrollBarHeight, scrollBarWidth, borderStyle]);
  return {
    scrollBarHeight: scrollBarHeight,
    scrollBarWidth: scrollBarWidth,
    hasVerticalScroll: hasVerticalScroll,
    hasHorizontalScroll: hasHorizontalScroll,
    scrollBorderOverlay: scrollBorderOverlay
  };
};
exports.useScrollBars = useScrollBars;