"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridKeyboardShortcuts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _button = require("../../button");
var _tool_tip = require("../../tool_tip");
var _popover = require("../../popover");
var _description_list = require("../../description_list");
var _text = require("../../text");
var _i18n = require("../../i18n");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
var useDataGridKeyboardShortcuts = function useDataGridKeyboardShortcuts() {
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var title = (0, _i18n.useEuiI18n)('euiKeyboardShortcuts.title', 'Keyboard shortcuts');
  var titleId = (0, _services.useGeneratedHtmlId)();
  var keyboardShortcuts = (0, _react.useMemo)(function () {
    return (0, _react2.jsx)(_popover.EuiPopover, {
      "data-test-subj": "dataGridKeyboardShortcutsPopover",
      isOpen: isOpen,
      closePopover: function closePopover() {
        return setIsOpen(false);
      },
      anchorPosition: "downRight",
      button: (0, _react2.jsx)(_tool_tip.EuiToolTip, {
        content: title,
        delay: "long"
      }, (0, _react2.jsx)(_button.EuiButtonIcon, {
        size: "xs",
        iconType: "keyboard",
        color: "text",
        "data-test-subj": "dataGridKeyboardShortcutsButton",
        onClick: function onClick() {
          return setIsOpen(!isOpen);
        },
        "aria-label": title
      }))
    }, (0, _react2.jsx)(_popover.EuiPopoverTitle, {
      paddingSize: "s"
    }, (0, _react2.jsx)("h2", {
      id: titleId
    }, title)), (0, _react2.jsx)(_text.EuiText, {
      className: "euiDataGrid__keyboardShortcuts",
      size: "xs"
    }, (0, _react2.jsx)(_description_list.EuiDescriptionList, {
      "aria-labelledby": titleId,
      type: "column",
      align: "center",
      compressed: true,
      gutterSize: "s",
      listItems: [{
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.upArrowTitle",
          default: "Up arrow"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.upArrowDescription",
          default: "Move one cell up"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.downArrowTitle",
          default: "Down arrow"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.downArrowDescription",
          default: "Move one cell down"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.rightArrowTitle",
          default: "Right arrow"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.rightArrowDescription",
          default: "Move one cell right"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.leftArrowTitle",
          default: "Left arrow"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.leftArrowDescription",
          default: "Move one cell left"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.homeTitle",
          default: "Home"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.homeDescription",
          default: "Move to the first cell of the current row"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.endTitle",
          default: "End"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.endDescription",
          default: "Move to the last cell of the current row"
        })
      }, {
        title: (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.ctrl",
          default: "Ctrl"
        })), ' ', (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.homeTitle",
          default: "Home"
        }))),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.ctrlHomeDescription",
          default: "Move to the first cell of the current page"
        })
      }, {
        title: (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.ctrl",
          default: "Ctrl"
        })), ' ', (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.endTitle",
          default: "End"
        }))),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.ctrlEndDescription",
          default: "Move to the last cell of the current page"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.pageUpTitle",
          default: "Page Up"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.pageUpDescription",
          default: "Go to the last row of the previous page"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.pageDownTitle",
          default: "Page Down"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.pageDownDescription",
          default: "Go to the first row of the next page"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.enterTitle",
          default: "Enter"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.enterDescription",
          default: "Open cell details and actions"
        })
      }, {
        title: (0, _react2.jsx)("kbd", null, (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.escapeTitle",
          default: "Escape"
        })),
        description: (0, _react2.jsx)(_i18n.EuiI18n, {
          token: "euiKeyboardShortcuts.escapeDescription",
          default: "Close cell details and actions"
        })
      }]
    })));
  }, [isOpen, title, titleId]);
  return {
    keyboardShortcuts: keyboardShortcuts
  };
};
exports.useDataGridKeyboardShortcuts = useDataGridKeyboardShortcuts;