"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridFullScreenSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../../services");
var _tool_tip = require("../../tool_tip");
var _button = require("../../button");
var _i18n = require("../../i18n");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
var GRID_IS_FULLSCREEN_CLASSNAME = 'euiDataGrid__restrictBody';
var useDataGridFullScreenSelector = function useDataGridFullScreenSelector() {
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isFullScreen = _useState2[0],
    setIsFullScreen = _useState2[1];
  var _useEuiI18n = (0, _i18n.useEuiI18n)(['euiFullscreenSelector.fullscreenButton', 'euiFullscreenSelector.fullscreenButtonActive'], ['Enter fullscreen', 'Exit fullscreen']),
    _useEuiI18n2 = _slicedToArray(_useEuiI18n, 2),
    fullScreenButton = _useEuiI18n2[0],
    fullScreenButtonActive = _useEuiI18n2[1];
  var controlBtnClasses = (0, _classnames.default)('euiDataGrid__controlBtn', {
    'euiDataGrid__controlBtn--active': isFullScreen
  });
  var fullScreenSelector = (0, _react.useMemo)(function () {
    return (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      content: isFullScreen ? (0, _react2.jsx)(_react.default.Fragment, null, fullScreenButtonActive, " (", (0, _react2.jsx)("kbd", null, "esc"), ")") : fullScreenButton,
      delay: "long"
    }, (0, _react2.jsx)(_button.EuiButtonIcon, {
      size: "xs",
      iconType: isFullScreen ? 'fullScreenExit' : 'fullScreen',
      color: "text",
      className: controlBtnClasses,
      "data-test-subj": "dataGridFullScreenButton",
      onClick: function onClick() {
        return setIsFullScreen(!isFullScreen);
      },
      "aria-label": isFullScreen ? fullScreenButtonActive : fullScreenButton
    }));
  }, [isFullScreen, controlBtnClasses, fullScreenButton, fullScreenButtonActive]);
  var handleGridKeyDown = (0, _react.useCallback)(function (event) {
    switch (event.key) {
      case _services.keys.ESCAPE:
        if (isFullScreen) {
          event.preventDefault();
          setIsFullScreen(false);
        }
        break;
    }
  }, [isFullScreen]);
  (0, _react.useEffect)(function () {
    // When the data grid is fullscreen, we add a class to the body to remove the extra scrollbar and stay above any fixed headers
    if (isFullScreen) {
      document.body.classList.add(GRID_IS_FULLSCREEN_CLASSNAME);
      return function () {
        document.body.classList.remove(GRID_IS_FULLSCREEN_CLASSNAME);
      };
    }
  }, [isFullScreen]);
  return {
    isFullScreen: isFullScreen,
    setIsFullScreen: setIsFullScreen,
    fullScreenSelector: fullScreenSelector,
    handleGridKeyDown: handleGridKeyDown
  };
};
exports.useDataGridFullScreenSelector = useDataGridFullScreenSelector;