"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataGridDisplaySelector = exports.startingStyles = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _i18n = require("../../i18n");
var _popover = require("../../popover");
var _button = require("../../button");
var _form = require("../../form");
var _flex = require("../../flex");
var _tool_tip = require("../../tool_tip");
var _data_grid_toolbar = require("./data_grid_toolbar");
var _react2 = require("@emotion/react");
var _excluded = ["onChange"],
  _excluded2 = ["onChange"];
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var startingStyles = {
  cellPadding: 'm',
  fontSize: 'm',
  border: 'all',
  stripes: false,
  rowHover: 'highlight',
  header: 'shade',
  footer: 'overline',
  stickyFooter: true
};

// These are the available options. They power the gridDensity hook and also the options in the render
exports.startingStyles = startingStyles;
var densityOptions = ['compact', 'normal', 'expanded'];
var densityStyles = {
  expanded: {
    fontSize: 'l',
    cellPadding: 'l'
  },
  normal: {
    fontSize: 'm',
    cellPadding: 'm'
  },
  compact: {
    fontSize: 's',
    cellPadding: 's'
  }
};
var convertGridStylesToSelection = function convertGridStylesToSelection(gridStyles) {
  if (gridStyles.fontSize === 's' && gridStyles.cellPadding === 's') return 'compact';
  if (gridStyles.fontSize === 'm' && gridStyles.cellPadding === 'm') return 'normal';
  if (gridStyles.fontSize === 'l' && gridStyles.cellPadding === 'l') return 'expanded';
  return '';
};

// Used to correctly format the icon name for the grid density icon
var capitalizeDensityString = function capitalizeDensityString(s) {
  return s[0].toUpperCase() + s.slice(1);
};

// Row height options and utilities
var rowHeightButtonOptions = ['undefined', 'auto', 'lineCount'];
var convertRowHeightsOptionsToSelection = function convertRowHeightsOptionsToSelection(rowHeightsOptions) {
  var defaultHeight = rowHeightsOptions.defaultHeight;
  if (defaultHeight === 'auto') {
    return rowHeightButtonOptions[1];
  }
  if (_typeof(defaultHeight) === 'object' && defaultHeight !== null && defaultHeight !== void 0 && defaultHeight.lineCount) {
    return rowHeightButtonOptions[2];
  }
  if (typeof defaultHeight === 'number' || _typeof(defaultHeight) === 'object' && defaultHeight.height) {
    return '';
  }
  return rowHeightButtonOptions[0];
};
var useDataGridDisplaySelector = function useDataGridDisplaySelector(showDisplaySelector, initialStyles, initialRowHeightsOptions) {
  var _rowHeightsOptions$de2;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isOpen = _useState2[0],
    setIsOpen = _useState2[1];
  var showDensityControls = (0, _data_grid_toolbar.getNestedObjectOptions)(showDisplaySelector, 'allowDensity');
  var showRowHeightControls = (0, _data_grid_toolbar.getNestedObjectOptions)(showDisplaySelector, 'allowRowHeight');

  // Track styles specified by the user at run time
  var _useState3 = (0, _react.useState)({}),
    _useState4 = _slicedToArray(_useState3, 2),
    userGridStyles = _useState4[0],
    setUserGridStyles = _useState4[1];
  var _useState5 = (0, _react.useState)({}),
    _useState6 = _slicedToArray(_useState5, 2),
    userRowHeightsOptions = _useState6[0],
    setUserRowHeightsOptions = _useState6[1];

  // Density logic
  var setGridStyles = (0, _react.useCallback)(function (density) {
    setUserGridStyles(densityStyles[density]);
  }, []);

  // Row height logic
  var _useState7 = (0, _react.useState)(2),
    _useState8 = _slicedToArray(_useState7, 2),
    lineCount = _useState8[0],
    setLineCount = _useState8[1];
  var setRowHeight = (0, _react.useCallback)(function (option) {
    var rowHeightsOptions = {
      rowHeights: {} // Unset all row-specific heights
    };

    if (option === 'auto') {
      rowHeightsOptions.defaultHeight = 'auto';
    } else if (option === 'lineCount') {
      rowHeightsOptions.defaultHeight = {
        lineCount: lineCount
      };
    } else {
      rowHeightsOptions.defaultHeight = undefined;
    }
    setUserRowHeightsOptions(rowHeightsOptions);
  }, [lineCount]);
  var setLineCountHeight = (0, _react.useCallback)(function (event) {
    var newLineCount = Number(event.target.value);
    if (newLineCount < 1) return; // Don't let users set a 0 or negative line count

    setLineCount(newLineCount);
    setUserRowHeightsOptions({
      rowHeights: {},
      // Unset all row-specific line counts
      defaultHeight: {
        lineCount: newLineCount
      }
    });
  }, []);

  // Merge the developer-specified configurations with user overrides
  var gridStyles = (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, initialStyles), userGridStyles);
  }, [initialStyles, userGridStyles]);
  var rowHeightsOptions = (0, _react.useMemo)(function () {
    return _objectSpread(_objectSpread({}, initialRowHeightsOptions), userRowHeightsOptions);
  }, [initialRowHeightsOptions, userRowHeightsOptions]);

  // Set UI controls based on current configurations, on init & when either developer or user settings change
  var gridDensity = (0, _react.useMemo)(function () {
    return convertGridStylesToSelection(gridStyles);
  }, [gridStyles]);
  var rowHeightSelection = (0, _react.useMemo)(function () {
    return convertRowHeightsOptionsToSelection(rowHeightsOptions);
  }, [rowHeightsOptions]);
  (0, _react.useEffect)(function () {
    var _rowHeightsOptions$de;
    // @ts-ignore - optional chaining operator handles types & cases that aren't lineCount
    setLineCount((rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : (_rowHeightsOptions$de = rowHeightsOptions.defaultHeight) === null || _rowHeightsOptions$de === void 0 ? void 0 : _rowHeightsOptions$de.lineCount) || 2);
    // @ts-ignore - same as above
  }, [rowHeightsOptions === null || rowHeightsOptions === void 0 ? void 0 : (_rowHeightsOptions$de2 = rowHeightsOptions.defaultHeight) === null || _rowHeightsOptions$de2 === void 0 ? void 0 : _rowHeightsOptions$de2.lineCount]);

  // Show a reset button whenever users manually change settings, and
  // invoke onChange callbacks (removing the callback value itself, so that only configuration values are returned)
  var _useState9 = (0, _react.useState)(false),
    _useState10 = _slicedToArray(_useState9, 2),
    showResetButton = _useState10[0],
    setShowResetButton = _useState10[1];
  (0, _services.useUpdateEffect)(function () {
    var _initialStyles$onChan;
    var hasUserChanges = Object.keys(userGridStyles).length > 0;
    if (hasUserChanges) setShowResetButton(true);
    var onChange = gridStyles.onChange,
      currentGridStyles = _objectWithoutProperties(gridStyles, _excluded);
    initialStyles === null || initialStyles === void 0 ? void 0 : (_initialStyles$onChan = initialStyles.onChange) === null || _initialStyles$onChan === void 0 ? void 0 : _initialStyles$onChan.call(initialStyles, currentGridStyles);
  }, [userGridStyles]);
  (0, _services.useUpdateEffect)(function () {
    var _initialRowHeightsOpt;
    var hasUserChanges = Object.keys(userRowHeightsOptions).length > 0;
    if (hasUserChanges) setShowResetButton(true);
    var onChange = rowHeightsOptions.onChange,
      currentRowHeightsOptions = _objectWithoutProperties(rowHeightsOptions, _excluded2);
    initialRowHeightsOptions === null || initialRowHeightsOptions === void 0 ? void 0 : (_initialRowHeightsOpt = initialRowHeightsOptions.onChange) === null || _initialRowHeightsOpt === void 0 ? void 0 : _initialRowHeightsOpt.call(initialRowHeightsOptions, currentRowHeightsOptions);
  }, [userRowHeightsOptions]);

  // Allow resetting to initial developer-specified configurations
  var resetToInitialState = (0, _react.useCallback)(function () {
    setUserGridStyles({});
    setUserRowHeightsOptions({});
    setShowResetButton(false);
  }, []);
  var buttonLabel = (0, _i18n.useEuiI18n)('euiDisplaySelector.buttonText', 'Display options');
  var resetButtonLabel = (0, _i18n.useEuiI18n)('euiDisplaySelector.resetButtonText', 'Reset to default');
  var displaySelector = showDensityControls || showRowHeightControls ? (0, _react2.jsx)(_popover.EuiPopover, {
    "data-test-subj": "dataGridDisplaySelectorPopover",
    isOpen: isOpen,
    closePopover: function closePopover() {
      return setIsOpen(false);
    },
    anchorPosition: "downRight",
    panelPaddingSize: "s",
    panelClassName: "euiDataGrid__displayPopoverPanel",
    button: (0, _react2.jsx)(_tool_tip.EuiToolTip, {
      content: buttonLabel,
      delay: "long"
    }, (0, _react2.jsx)(_button.EuiButtonIcon, {
      size: "xs",
      iconType: gridDensity ? "tableDensity".concat(capitalizeDensityString(gridDensity)) : 'tableDensityNormal',
      className: "euiDataGrid__controlBtn",
      color: "text",
      "data-test-subj": "dataGridDisplaySelectorButton",
      onClick: function onClick() {
        return setIsOpen(!isOpen);
      },
      "aria-label": buttonLabel
    }))
  }, showDensityControls && (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiDisplaySelector.densityLabel', 'euiDisplaySelector.labelCompact', 'euiDisplaySelector.labelNormal', 'euiDisplaySelector.labelExpanded'],
    defaults: ['Density', 'Compact', 'Normal', 'Expanded']
  }, function (_ref) {
    var _ref2 = _slicedToArray(_ref, 4),
      densityLabel = _ref2[0],
      labelCompact = _ref2[1],
      labelNormal = _ref2[2],
      labelExpanded = _ref2[3];
    return (0, _react2.jsx)(_form.EuiFormRow, {
      label: densityLabel,
      display: "columnCompressed"
    }, (0, _react2.jsx)(_button.EuiButtonGroup, {
      legend: densityLabel,
      buttonSize: "compressed",
      isFullWidth: true,
      options: [{
        id: densityOptions[0],
        label: labelCompact
      }, {
        id: densityOptions[1],
        label: labelNormal
      }, {
        id: densityOptions[2],
        label: labelExpanded
      }],
      onChange: setGridStyles,
      idSelected: gridDensity,
      "data-test-subj": "densityButtonGroup"
    }));
  }), showRowHeightControls && (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiDisplaySelector.rowHeightLabel', 'euiDisplaySelector.labelSingle', 'euiDisplaySelector.labelAuto', 'euiDisplaySelector.labelCustom', 'euiDisplaySelector.lineCountLabel'],
    defaults: ['Row height', 'Single', 'Auto fit', 'Custom', 'Lines per row']
  }, function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 5),
      rowHeightLabel = _ref4[0],
      labelSingle = _ref4[1],
      labelAuto = _ref4[2],
      labelCustom = _ref4[3],
      lineCountLabel = _ref4[4];
    return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_form.EuiFormRow, {
      label: rowHeightLabel,
      display: "columnCompressed"
    }, (0, _react2.jsx)(_button.EuiButtonGroup, {
      legend: rowHeightLabel,
      buttonSize: "compressed",
      isFullWidth: true,
      options: [{
        id: rowHeightButtonOptions[0],
        label: labelSingle
      }, {
        id: rowHeightButtonOptions[1],
        label: labelAuto
      }, {
        id: rowHeightButtonOptions[2],
        label: labelCustom
      }],
      onChange: setRowHeight,
      idSelected: rowHeightSelection,
      "data-test-subj": "rowHeightButtonGroup"
    })), rowHeightSelection === rowHeightButtonOptions[2] && (0, _react2.jsx)(_form.EuiFormRow, {
      label: lineCountLabel,
      display: "columnCompressed"
    }, (0, _react2.jsx)(_form.EuiRange, {
      compressed: true,
      fullWidth: true,
      showInput: true,
      min: 1,
      max: 20,
      step: 1,
      value: lineCount,
      onChange: setLineCountHeight,
      "data-test-subj": "lineCountNumber"
    })));
  }), showResetButton && (0, _react2.jsx)(_popover.EuiPopoverFooter, null, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    justifyContent: "flexEnd",
    responsive: false
  }, (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)("div", null, (0, _react2.jsx)(_button.EuiButtonEmpty, {
    flush: "both",
    size: "xs",
    onClick: resetToInitialState,
    "data-test-subj": "resetDisplaySelector"
  }, resetButtonLabel)))))) : null;
  return [displaySelector, gridStyles, rowHeightsOptions];
};
exports.useDataGridDisplaySelector = useDataGridDisplaySelector;