"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiColorStopThumb = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _utils = require("./utils");
var _utils2 = require("../utils");
var _services = require("../../../services");
var _button = require("../../button");
var _color_picker = require("../color_picker");
var _flex = require("../../flex");
var _form = require("../../form");
var _i18n = require("../../i18n");
var _popover = require("../../popover");
var _accessibility = require("../../accessibility");
var _spacer = require("../../spacer");
var _range_thumb = require("../../form/range/range_thumb");
var _color_stop_thumb = require("./color_stop_thumb.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "stop", "color", "onChange", "onFocus", "onRemove", "globalMin", "globalMax", "localMin", "localMax", "min", "max", "isRangeMin", "isRangeMax", "parentRef", "colorPickerMode", "colorPickerShowAlpha", "colorPickerSwatches", "disabled", "readOnly", "isPopoverOpen", "openPopover", "closePopover", "data-index", "aria-valuetext", "style", "valueInputProps"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var EuiColorStopThumb = function EuiColorStopThumb(_ref) {
  var className = _ref.className,
    stop = _ref.stop,
    color = _ref.color,
    onChange = _ref.onChange,
    onFocus = _ref.onFocus,
    onRemove = _ref.onRemove,
    globalMin = _ref.globalMin,
    globalMax = _ref.globalMax,
    localMin = _ref.localMin,
    localMax = _ref.localMax,
    min = _ref.min,
    max = _ref.max,
    _ref$isRangeMin = _ref.isRangeMin,
    isRangeMin = _ref$isRangeMin === void 0 ? false : _ref$isRangeMin,
    _ref$isRangeMax = _ref.isRangeMax,
    isRangeMax = _ref$isRangeMax === void 0 ? false : _ref$isRangeMax,
    parentRef = _ref.parentRef,
    colorPickerMode = _ref.colorPickerMode,
    colorPickerShowAlpha = _ref.colorPickerShowAlpha,
    colorPickerSwatches = _ref.colorPickerSwatches,
    disabled = _ref.disabled,
    readOnly = _ref.readOnly,
    isPopoverOpen = _ref.isPopoverOpen,
    openPopover = _ref.openPopover,
    closePopover = _ref.closePopover,
    dataIndex = _ref['data-index'],
    ariaValueText = _ref['aria-valuetext'],
    style = _ref.style,
    _ref$valueInputProps = _ref.valueInputProps,
    valueInputProps = _ref$valueInputProps === void 0 ? {} : _ref$valueInputProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  var background = (0, _react.useMemo)(function () {
    var chromaColor = (0, _utils2.getChromaColor)(color, colorPickerShowAlpha);
    return chromaColor ? chromaColor.css() : undefined;
  }, [color, colorPickerShowAlpha]);
  var _useState = (0, _react.useState)(isPopoverOpen),
    _useState2 = _slicedToArray(_useState, 2),
    hasFocus = _useState2[0],
    setHasFocus = _useState2[1];
  var _useState3 = (0, _react.useState)((0, _utils.isColorInvalid)(color, colorPickerShowAlpha)),
    _useState4 = _slicedToArray(_useState3, 2),
    colorIsInvalid = _useState4[0],
    setColorIsInvalid = _useState4[1];
  var _useState5 = (0, _react.useState)((0, _utils.isStopInvalid)(stop)),
    _useState6 = _slicedToArray(_useState5, 2),
    stopIsInvalid = _useState6[0],
    setStopIsInvalid = _useState6[1];
  var _useState7 = (0, _react.useState)(null),
    _useState8 = _slicedToArray(_useState7, 2),
    numberInputRef = _useState8[0],
    setNumberInputRef = _useState8[1];
  var popoverRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(function () {
    if (isPopoverOpen && popoverRef && popoverRef.current) {
      popoverRef.current.positionPopoverFixed();
    }
  }, [isPopoverOpen, stop]);
  var getStopFromMouseLocationFn = function getStopFromMouseLocationFn(location) {
    // Guard against `null` ref in usage
    return (0, _utils.getStopFromMouseLocation)(location, parentRef, globalMin, globalMax);
  };
  var getPositionFromStopFn = function getPositionFromStopFn(stop) {
    // Guard against `null` ref in usage
    return (0, _utils.getPositionFromStop)(stop, parentRef, globalMin, globalMax);
  };
  var handleOnRemove = function handleOnRemove() {
    if (onRemove) {
      closePopover();
      onRemove();
    }
  };
  var handleFocus = function handleFocus() {
    setHasFocus(true);
    if (onFocus) {
      onFocus();
    }
  };
  var setHasFocusTrue = function setHasFocusTrue() {
    return setHasFocus(true);
  };
  var setHasFocusFalse = function setHasFocusFalse() {
    return setHasFocus(false);
  };
  var handleColorChange = function handleColorChange(value) {
    setColorIsInvalid((0, _utils.isColorInvalid)(value, colorPickerShowAlpha));
    onChange({
      stop: stop,
      color: value
    });
  };
  var handleStopChange = function handleStopChange(value) {
    var willBeInvalid = value > localMax || value < localMin;
    if (willBeInvalid) {
      if (value > localMax) {
        value = localMax;
      }
      if (value < localMin) {
        value = localMin;
      }
    }
    setStopIsInvalid((0, _utils.isStopInvalid)(value));
    onChange({
      stop: value,
      color: color
    });
  };
  var handleStopInputChange = function handleStopInputChange(e) {
    var value = parseFloat(e.target.value);
    var willBeInvalid = value > globalMax || value < globalMin;
    if (willBeInvalid) {
      if (value > globalMax && max != null) {
        value = globalMax;
      }
      if (value < globalMin && min != null) {
        value = globalMin;
      }
    }
    setStopIsInvalid((0, _utils.isStopInvalid)(value));
    onChange({
      stop: value,
      color: color
    });
  };
  var handlePointerChange = function handlePointerChange(location, isFirstInteraction) {
    if (isFirstInteraction) return; // Prevents change on the initial MouseDown event
    if (parentRef == null) {
      return;
    }
    var newStop = getStopFromMouseLocationFn(location);
    handleStopChange(newStop);
  };
  var handleKeyDown = function handleKeyDown(event) {
    switch (event.key) {
      case _services.keys.ENTER:
        event.preventDefault();
        openPopover();
        break;
      case _services.keys.ARROW_LEFT:
        event.preventDefault();
        if (readOnly) return;
        handleStopChange(stop - 1);
        break;
      case _services.keys.ARROW_RIGHT:
        event.preventDefault();
        if (readOnly) return;
        handleStopChange(stop + 1);
        break;
    }
  };
  var _useMouseMove = (0, _services.useMouseMove)(handlePointerChange),
    _useMouseMove2 = _slicedToArray(_useMouseMove, 2),
    handleMouseDown = _useMouseMove2[0],
    handleInteraction = _useMouseMove2[1];
  var handleOnMouseDown = function handleOnMouseDown(e) {
    if (!readOnly) {
      handleMouseDown(e);
    }
    openPopover();
  };
  var handleTouchInteraction = function handleTouchInteraction(e) {
    if (!readOnly) {
      handleInteraction(e);
    }
  };
  var handleTouchStart = function handleTouchStart(e) {
    handleTouchInteraction(e);
    if (!isPopoverOpen) {
      openPopover();
    }
  };
  var euiTheme = (0, _services.useEuiTheme)();
  var popoverStyles = (0, _color_stop_thumb.euiColorStopThumbPopoverStyles)(euiTheme);
  var cssPopoverStyles = [popoverStyles.euiColorStopThumbPopover, (hasFocus || isPopoverOpen) && popoverStyles.hasFocus];
  var thumbStyles = (0, _color_stop_thumb.euiColorStopThumbStyles)(euiTheme);
  var cssThumbStyles = [thumbStyles.euiColorStopThumb, isPopoverOpen && thumbStyles.isPopoverOpen];
  var colorStopStyles = (0, _color_stop_thumb.euiColorStopStyles)(euiTheme);
  var cssColorStopStyles = colorStopStyles.euiColorStop;
  var classes = (0, _classnames.default)('euiColorStopPopover', className);
  return (0, _react2.jsx)(_popover.EuiPopover, _extends({
    css: cssPopoverStyles
  }, rest, {
    ref: popoverRef,
    className: classes,
    anchorClassName: "euiColorStopThumbPopover__anchor",
    panelPaddingSize: "s",
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    initialFocus: numberInputRef || undefined,
    focusTrapProps: {
      clickOutsideDisables: false
    },
    panelProps: {
      css: numberInputRef ? undefined : popoverStyles.isLoadingPanel
    },
    style: _objectSpread(_objectSpread({}, style), {}, {
      left: "".concat(getPositionFromStopFn(stop), "%")
    }),
    button: (0, _react2.jsx)(_i18n.EuiI18n, {
      tokens: ['euiColorStopThumb.buttonAriaLabel', 'euiColorStopThumb.buttonTitle'],
      defaults: ['Press the Enter key to modify this stop. Press Escape to focus the group', 'Click to edit, drag to reposition']
    }, function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 2),
        buttonAriaLabel = _ref3[0],
        buttonTitle = _ref3[1];
      var ariaLabel = buttonAriaLabel;
      var title = buttonTitle;
      return (0, _react2.jsx)(_range_thumb.EuiRangeThumb, {
        "data-test-subj": "euiColorStopThumb",
        "data-index": dataIndex,
        min: localMin,
        max: localMax,
        value: stop,
        onFocus: handleFocus,
        onBlur: setHasFocusFalse,
        onMouseOver: setHasFocusTrue,
        onMouseOut: setHasFocusFalse,
        onKeyDown: handleKeyDown,
        onMouseDown: handleOnMouseDown,
        onTouchStart: handleTouchStart,
        onTouchMove: handleTouchInteraction,
        "aria-valuetext": ariaValueText,
        "aria-label": ariaLabel,
        title: title,
        className: "euiColorStopThumb",
        css: cssThumbStyles,
        tabIndex: -1,
        style: {
          background: background
        },
        disabled: disabled
      });
    })
  }), (0, _react2.jsx)("div", {
    className: "euiColorStop",
    css: cssColorStopStyles,
    "data-test-subj": "euiColorStopPopover"
  }, (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("p", {
    "aria-live": "polite"
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiColorStopThumb.screenReaderAnnouncement",
    default: "A popup with a color stop edit form opened. Tab forward to cycle through form controls or press escape to close this popup."
  }))), (0, _react2.jsx)(_flex.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, (0, _react2.jsx)(_flex.EuiFlexItem, null, (0, _react2.jsx)(_i18n.EuiI18n, {
    tokens: ['euiColorStopThumb.stopLabel', 'euiColorStopThumb.stopErrorMessage'],
    defaults: ['Stop value', 'Value is out of range']
  }, function (_ref4) {
    var _ref5 = _slicedToArray(_ref4, 2),
      stopLabel = _ref5[0],
      stopErrorMessage = _ref5[1];
    return (0, _react2.jsx)(_form.EuiFormRow, {
      label: stopLabel,
      display: "rowCompressed",
      isInvalid: stopIsInvalid,
      error: stopIsInvalid ? stopErrorMessage : null
    }, (0, _react2.jsx)(_form.EuiFieldNumber, _extends({}, valueInputProps, {
      inputRef: setNumberInputRef,
      compressed: true,
      readOnly: readOnly,
      min: isRangeMin || min == null ? undefined : localMin,
      max: isRangeMax || max == null ? undefined : localMax,
      value: (0, _utils.isStopInvalid)(stop) ? '' : stop,
      isInvalid: stopIsInvalid,
      onChange: handleStopInputChange
    })));
  })), !readOnly && (0, _react2.jsx)(_flex.EuiFlexItem, {
    grow: false
  }, (0, _react2.jsx)(_form.EuiFormRow, {
    display: "rowCompressed",
    hasEmptyLabelSpace: true
  }, (0, _react2.jsx)(_i18n.EuiI18n, {
    token: "euiColorStopThumb.removeLabel",
    default: "Remove this stop"
  }, function (removeLabel) {
    return (0, _react2.jsx)(_button.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      "aria-label": removeLabel,
      title: removeLabel,
      disabled: !onRemove,
      onClick: handleOnRemove
    });
  })))), !readOnly && (0, _react2.jsx)(_spacer.EuiSpacer, {
    size: "s"
  }), (0, _react2.jsx)(_color_picker.EuiColorPicker, {
    readOnly: readOnly,
    onChange: handleColorChange,
    color: color,
    mode: readOnly ? 'secondaryInput' : colorPickerMode,
    swatches: colorPickerSwatches,
    display: "inline",
    showAlpha: colorPickerShowAlpha,
    isInvalid: colorIsInvalid,
    secondaryInputDisplay: colorPickerMode === 'swatch' ? 'none' : 'bottom'
  })));
};
exports.EuiColorStopThumb = EuiColorStopThumb;
EuiColorStopThumb.propTypes = {
  className: _propTypes.default.string,
  onChange: _propTypes.default.func.isRequired,
  onFocus: _propTypes.default.func,
  onRemove: _propTypes.default.func,
  globalMin: _propTypes.default.number.isRequired,
  globalMax: _propTypes.default.number.isRequired,
  localMin: _propTypes.default.number.isRequired,
  localMax: _propTypes.default.number.isRequired,
  min: _propTypes.default.number,
  max: _propTypes.default.number,
  isRangeMin: _propTypes.default.bool,
  isRangeMax: _propTypes.default.bool,
  parentRef: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf([null])]),
  colorPickerMode: _propTypes.default.oneOf(["default", "swatch", "picker", "secondaryInput"]).isRequired,
  colorPickerShowAlpha: _propTypes.default.bool,
  colorPickerSwatches: _propTypes.default.arrayOf(_propTypes.default.string.isRequired),
  disabled: _propTypes.default.bool,
  readOnly: _propTypes.default.bool,
  isPopoverOpen: _propTypes.default.bool.isRequired,
  openPopover: _propTypes.default.func.isRequired,
  closePopover: _propTypes.default.func.isRequired,
  "data-index": _propTypes.default.string,
  "aria-valuetext": _propTypes.default.string,
  style: _propTypes.default.any,
  valueInputProps: _propTypes.default.any,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  stop: _propTypes.default.number.isRequired,
  color: _propTypes.default.string.isRequired
};