"use strict";

var _react = _interopRequireDefault(require("react"));
var _color_picker = require("./color_picker");
var _form = require("../form");
var _services = require("../../services");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
var ColorPicker = function ColorPicker() {
  var _useColorPickerState = (0, _services.useColorPickerState)('#D36086'),
    _useColorPickerState2 = _slicedToArray(_useColorPickerState, 3),
    color = _useColorPickerState2[0],
    setColor = _useColorPickerState2[1],
    errors = _useColorPickerState2[2];
  return (0, _react2.jsx)(_form.EuiFormRow, {
    label: "Pick a color",
    isInvalid: !!errors,
    error: errors
  }, (0, _react2.jsx)(_color_picker.EuiColorPicker, {
    onChange: setColor,
    color: color,
    isInvalid: !!errors
  }));
};
beforeEach(function () {
  cy.realMount((0, _react2.jsx)(ColorPicker, null));
});
describe('EuiColorPicker', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the picker is opened', function () {
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').realClick();
      cy.get('div[data-test-subj="euiColorPickerPopover"]').should('exist');
      cy.checkAxe();
      cy.realPress('Escape');
      cy.get('div[data-test-subj="euiColorPickerPopover"]').should('not.exist');
      cy.checkAxe();
    });
    it('has zero violations after keyboard interaction', function () {
      cy.realPress('Tab');
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').should('have.focus');
      cy.realPress('Enter');
      cy.repeatRealPress('ArrowDown', 5);
      cy.repeatRealPress('ArrowRight', 3);
      cy.realPress('Escape');
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').should('have.focus');
      cy.get('input[data-test-subj="euiColorPickerAnchor"]').should('have.attr', 'value', '#C9557B');
      cy.checkAxe();
    });
  });
});