"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseLineRanges = exports.nodeToHtml = exports.isAstElement = exports.highlightByLine = exports.getHtmlContent = exports.checkSupportedLanguage = exports.SUPPORTED_LANGUAGES = exports.NEW_LINE_REGEX_GLOBAL = exports.NEW_LINE_REGEX = exports.DEFAULT_LANGUAGE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _refractor = require("refractor");
var _css = require("@emotion/css");
var _code_block_annotations = require("./code_block_annotations");
var _code_block_line = require("./code_block_line.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
var SUPPORTED_LANGUAGES = (0, _refractor.listLanguages)();
exports.SUPPORTED_LANGUAGES = SUPPORTED_LANGUAGES;
var DEFAULT_LANGUAGE = 'text';

/**
 * Platform-agnostic new line regex that safely matches all standard
 * line termination conventions:
 * - LF: Unix-based platforms and JS-native sources like text areas
 * - CRLF: Windows
 * - CR: Mac Classic; to support files saved a long time ago
 */
exports.DEFAULT_LANGUAGE = DEFAULT_LANGUAGE;
var NEW_LINE_REGEX = /\r\n|\r|\n/;

/**
 * Platform-agnostic global new line regex that safely matches all standard
 * line termination conventions.
 * See [NEW_LINE_REGEX]{@link NEW_LINE_REGEX} for more details.
 */
exports.NEW_LINE_REGEX = NEW_LINE_REGEX;
var NEW_LINE_REGEX_GLOBAL = new RegExp(NEW_LINE_REGEX, 'g');
exports.NEW_LINE_REGEX_GLOBAL = NEW_LINE_REGEX_GLOBAL;
var checkSupportedLanguage = function checkSupportedLanguage(language) {
  return SUPPORTED_LANGUAGES.includes(language) ? language : DEFAULT_LANGUAGE;
};
exports.checkSupportedLanguage = checkSupportedLanguage;
var getHtmlContent = function getHtmlContent(data, children) {
  if (!Array.isArray(data) || data.length < 1) {
    return children;
  }
  return data.map(nodeToHtml);
};
exports.getHtmlContent = getHtmlContent;
var isAstElement = function isAstElement(node) {
  return node.hasOwnProperty('type') && node.type === 'element';
};
exports.isAstElement = isAstElement;
var nodeToHtml = function nodeToHtml(node, idx, nodes) {
  var depth = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
  var key = "node-".concat(depth, "-").concat(idx);
  if (isAstElement(node)) {
    var properties = node.properties,
      tagName = node.tagName,
      children = node.children;
    return /*#__PURE__*/(0, _react.createElement)(tagName, _objectSpread(_objectSpread({}, properties), {}, {
      key: key,
      className: (0, _css.cx)(properties.className)
    }), children && children.map(function (el, i) {
      return (
        // @ts-ignore - using a custom type here to handle JSX annotations
        el.type === 'annotation' ? (0, _react2.jsx)(_code_block_annotations.EuiCodeBlockAnnotation, {
          className: "euiCodeBlock__lineAnnotation",
          lineNumber: el.lineNumber,
          children: el.annotation,
          key: i
        }) : nodeToHtml(el, i, nodes, depth + 1)
      );
    }));
  }
  return (0, _react2.jsx)(_react.default.Fragment, {
    key: key
  }, node.value);
};

/**
 * Line utils specific to EuiCodeBlock
 */
exports.nodeToHtml = nodeToHtml;
// Approximate width of a single digit/character
var CHAR_SIZE = 8;

// Creates an array of numbers from comma-separeated
// string of numbers or number ranges using `-`
// (e.g., "1, 3-10, 15")
var parseLineRanges = function parseLineRanges(ranges) {
  var highlights = [];
  ranges.replace(/\s/g, '').split(',').forEach(function (line) {
    if (line.includes('-')) {
      var range = line.split('-').map(Number);
      for (var i = range[0]; i <= range[1]; i++) {
        highlights.push(i);
      }
    } else {
      highlights.push(Number(line));
    }
  });
  return highlights;
};
exports.parseLineRanges = parseLineRanges;
var addLineData = function addLineData(nodes, data) {
  return nodes.reduce(function (result, node) {
    var lineStart = data.lineNumber;
    if (node.type === 'text') {
      if (!node.value.match(NEW_LINE_REGEX)) {
        node.lineStart = lineStart;
        node.lineEnd = lineStart;
        result.push(node);
      } else {
        var lines = node.value.split(NEW_LINE_REGEX);
        lines.forEach(function (line, i) {
          var num = i === 0 ? data.lineNumber : ++data.lineNumber;
          result.push({
            type: 'text',
            value: i === lines.length - 1 ? line : "".concat(line, "\n"),
            lineStart: num,
            lineEnd: num
          });
        });
      }
      return result;
    }
    if (node.children && node.children.length) {
      var _first$lineStart, _last$lineEnd;
      var children = addLineData(node.children, data);
      var first = children[0];
      var last = children[children.length - 1];
      var start = (_first$lineStart = first.lineStart) !== null && _first$lineStart !== void 0 ? _first$lineStart : lineStart;
      var end = (_last$lineEnd = last.lineEnd) !== null && _last$lineEnd !== void 0 ? _last$lineEnd : lineStart;
      if (start !== end) {
        children.forEach(function (node) {
          result.push(node);
        });
      } else {
        node.lineStart = start;
        node.lineEnd = end;
        node.children = children;
        result.push(node);
      }
      return result;
    }
    result.push(node);
    return result;
  }, []);
};
function wrapLines(nodes, options, euiTheme) {
  var grouped = [];
  nodes.forEach(function (node) {
    var lineStart = node.lineStart - 1;
    if (grouped[lineStart]) {
      grouped[lineStart].push(node);
    } else {
      grouped[lineStart] = [node];
    }
  });
  var wrapped = [];
  grouped.forEach(function (node, i) {
    var children = node;
    var styles = (0, _code_block_line.euiCodeBlockLineStyles)(euiTheme);
    var lineStyles = (0, _css.cx)([styles.euiCodeBlock__line, options.showLineNumbers && styles.hasLineNumbers]);
    if (options.showLineNumbers) {
      var _properties, _options$annotations;
      var lineNumber = i + 1;
      var digits = grouped.length.toString().length;
      var width = digits * CHAR_SIZE;

      // Line text element and highlights
      var highlights = options.highlight ? parseLineRanges(options.highlight) : [];
      var lineTextStyles = (0, _css.cx)([styles.lineText.euiCodeBlock__lineText, highlights.includes(lineNumber) && styles.lineText.isHighlighted]);
      var lineTextElement = {
        type: 'element',
        tagName: 'span',
        properties: {
          className: ['euiCodeBlock__lineText', lineTextStyles]
        },
        children: node
      };

      // Line number column/wrapper
      var lineNumberWrapperStyles = (0, _css.cx)(styles.lineNumber.euiCodeBlock__lineNumberWrapper);
      var lineNumberWrapperElement = {
        type: 'element',
        tagName: 'span',
        properties: {
          style: {
            inlineSize: width
          },
          className: ['euiCodeBlock__lineNumberWrapper', lineNumberWrapperStyles]
        },
        children: []
      };

      // Line number element
      var lineNumberStyles = (0, _css.cx)(styles.lineNumber.euiCodeBlock__lineNumber);
      var lineNumberElement = {
        type: 'element',
        tagName: 'span',
        properties: (_properties = {
          className: ['euiCodeBlock__lineNumber', lineNumberStyles]
        }, _defineProperty(_properties, 'data-line-number', lineNumber), _defineProperty(_properties, 'aria-hidden', true), _properties),
        children: []
      };
      lineNumberWrapperElement.children.push(lineNumberElement);

      // Annotation element
      var hasAnnotation = (_options$annotations = options.annotations) === null || _options$annotations === void 0 ? void 0 : _options$annotations.hasOwnProperty(lineNumber);
      if (hasAnnotation) {
        var annotationElement = {
          type: 'annotation',
          annotation: options.annotations[lineNumber],
          lineNumber: lineNumber
        };
        lineNumberWrapperElement.children.push(annotationElement);
      }
      children = [lineNumberWrapperElement, lineTextElement];
    }
    wrapped.push({
      type: 'element',
      tagName: 'span',
      properties: {
        className: ['euiCodeBlock__line', lineStyles]
      },
      children: children
    });
  });
  return wrapped;
}
var highlightByLine = function highlightByLine(children, language, data, euiTheme) {
  return wrapLines(addLineData((0, _refractor.highlight)(children, language), {
    lineNumber: data.start
  }), {
    showLineNumbers: data.show,
    highlight: data.highlight,
    annotations: data.annotations
  }, euiTheme);
};
exports.highlightByLine = highlightByLine;