"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFullScreen = exports.EuiCodeBlockFullScreenWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../services");
var _i18n = require("../i18n");
var _button = require("../button");
var _focus_trap = require("../focus_trap");
var _overlay_mask = require("../overlay_mask");
var _code_block = require("./code_block.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
/**
 * Hook that returns fullscreen-related state/logic/utils
 */
var useFullScreen = function useFullScreen(_ref) {
  var overflowHeight = _ref.overflowHeight;
  var showFullScreenButton = !!overflowHeight;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    isFullScreen = _useState2[0],
    setIsFullScreen = _useState2[1];
  var toggleFullScreen = (0, _react.useCallback)(function () {
    setIsFullScreen(function (isFullScreen) {
      return !isFullScreen;
    });
  }, []);
  var onKeyDown = (0, _react.useCallback)(function (event) {
    if (event.key === _services.keys.ESCAPE) {
      // We need to make sure annotation Escape keypresses don't also cause fullscreen mode to close
      var focus = document.activeElement;
      var isAnnotationPopover = !!(focus !== null && focus !== void 0 && focus.dataset.popoverOpen) || !!(focus !== null && focus !== void 0 && focus.closest('[data-popover-open]'));
      if (!isAnnotationPopover) {
        event.preventDefault();
        event.stopPropagation();
        setIsFullScreen(false);
      }
    }
  }, []);
  var _useEuiI18n = (0, _i18n.useEuiI18n)(['euiCodeBlockFullScreen.fullscreenCollapse', 'euiCodeBlockFullScreen.fullscreenExpand'], ['Collapse', 'Expand']),
    _useEuiI18n2 = _slicedToArray(_useEuiI18n, 2),
    fullscreenCollapse = _useEuiI18n2[0],
    fullscreenExpand = _useEuiI18n2[1];
  var fullScreenButton = (0, _react.useMemo)(function () {
    return showFullScreenButton ? (0, _react2.jsx)(_button.EuiButtonIcon, {
      className: "euiCodeBlock__fullScreenButton",
      onClick: toggleFullScreen,
      iconType: isFullScreen ? 'fullScreenExit' : 'fullScreen',
      color: "text",
      "aria-label": isFullScreen ? fullscreenCollapse : fullscreenExpand
    }) : null;
  }, [showFullScreenButton, toggleFullScreen, isFullScreen, fullscreenCollapse, fullscreenExpand]);
  return {
    fullScreenButton: fullScreenButton,
    isFullScreen: isFullScreen,
    onKeyDown: onKeyDown
  };
};

/**
 * Portalled full screen wrapper
 */
exports.useFullScreen = useFullScreen;
var EuiCodeBlockFullScreenWrapper = function EuiCodeBlockFullScreenWrapper(_ref2) {
  var children = _ref2.children;
  var euiThemeContext = (0, _services.useEuiTheme)();
  var styles = (0, _code_block.euiCodeBlockStyles)(euiThemeContext);
  var cssStyles = [styles.euiCodeBlock, styles.l,
  // Force fullscreen to use large font
  styles.isFullScreen];
  return (0, _react2.jsx)(_overlay_mask.EuiOverlayMask, null, (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
    scrollLock: true,
    preventScrollOnFocus: true,
    clickOutsideDisables: true
  }, (0, _react2.jsx)("div", {
    className: "euiCodeBlockFullScreen",
    css: cssStyles
  }, children)));
};
exports.EuiCodeBlockFullScreenWrapper = EuiCodeBlockFullScreenWrapper;