"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiBreadcrumbStyles = exports.euiBreadcrumbContentStyles = void 0;
var _react = require("@emotion/react");
var _color = require("../../services/color");
var _global_styling = require("../../global_styling");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1k7t4ns-isCollapsed",
  styles: "flex-shrink:0;label:isCollapsed;"
} : {
  name: "1k7t4ns-isCollapsed",
  styles: "flex-shrink:0;label:isCollapsed;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "p0bcva-isTruncated",
  styles: "overflow:hidden;label:isTruncated;"
} : {
  name: "p0bcva-isTruncated",
  styles: "overflow:hidden;label:isTruncated;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiBreadcrumbStyles = function euiBreadcrumbStyles(euiThemeContext) {
  // Styles cast to <li> element
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiBreadcrumb: /*#__PURE__*/(0, _react.css)("align-items:center;display:flex;", (0, _global_styling.logicalCSS)(
    // See .euiBreadcrumbs__list's negative margin-bottom
    'margin-bottom', euiTheme.size.xs), ";;label:euiBreadcrumb;"),
    isTruncated: _ref2,
    isCollapsed: _ref,
    // Types
    page: /*#__PURE__*/(0, _react.css)("&:not(:last-of-type){&:after{background:", euiTheme.colors.lightShade, ";content:'';flex-shrink:0;", (0, _global_styling.logicalCSS)('margin-top', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('margin-bottom', 0), " ", (0, _global_styling.logicalCSS)('margin-horizontal', euiTheme.size.s), " ", (0, _global_styling.logicalCSS)('height', euiTheme.size.base), " ", (0, _global_styling.logicalCSS)('width', '1px'), " transform:translateY(-1px) rotate(15deg);}};label:page;"),
    application: /*#__PURE__*/(0, _react.css)("&:not(:last-of-type){", (0, _global_styling.logicalCSS)('margin-right', "-".concat(euiTheme.size.xs)), ";};label:application;")
  };
};
exports.euiBreadcrumbStyles = euiBreadcrumbStyles;
var euiBreadcrumbContentStyles = function euiBreadcrumbContentStyles(euiThemeContext) {
  // Styles cast to <a>, <span>, or collapsed <button> elements
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiBreadcrumb__content: /*#__PURE__*/(0, _react.css)("font-weight:", euiTheme.font.weight.medium, ";text-align:center;vertical-align:baseline;;label:euiBreadcrumb__content;"),
    isTruncated: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)((0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 10;
    })), ";;label:isTruncated;"),
    isTruncatedLast: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)('none'), ";;label:isTruncatedLast;"),
    // Types
    page: /*#__PURE__*/(0, _react.css)("&:is(a):focus{", (0, _global_styling.euiFocusRing)(euiThemeContext, 'inset'), ";}&:is(button):focus{", (0, _global_styling.euiFocusRing)(euiThemeContext, 'center'), ";};label:page;"),
    application: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiFontSize)(euiThemeContext, 'xs'), ";background-color:", (0, _color.transparentize)(euiTheme.colors.darkestShade, 0.2), ";clip-path:polygon(\n        0 0,\n        calc(100% - ", euiTheme.size.s, ") 0,\n        100% 50%,\n        calc(100% - ", euiTheme.size.s, ") 100%,\n        0 100%,\n        ", euiTheme.size.s, " 50%\n      );color:", euiTheme.colors.darkestShade, ";line-height:", euiTheme.size.base, ";", (0, _global_styling.logicalCSS)('padding-vertical', euiTheme.size.xs), " ", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.base), " &:is(a),&:is(button){background-color:", (0, _color.transparentize)(euiTheme.colors.primary, 0.2), ";color:", euiTheme.colors.link, ";:focus{", (0, _global_styling.euiFocusRing)(euiThemeContext, 'inset'), ";:focus-visible{border-radius:", euiTheme.border.radius.medium, ";clip-path:none;}}};label:application;"),
    applicationStyles: {
      onlyChild: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";clip-path:none;", (0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.m), ",;;label:onlyChild;"),
      firstChild: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalBorderRadiusCSS)("".concat(euiTheme.border.radius.medium, " 0 0 ").concat(euiTheme.border.radius.medium), true), " clip-path:polygon(\n          0 0,\n          calc(100% - ", euiTheme.size.s, ") 0,\n          100% 50%,\n          calc(100% - ", euiTheme.size.s, ") 100%,\n          0 100%\n        );", (0, _global_styling.logicalCSS)('padding-left', euiTheme.size.m), ",;;label:firstChild;"),
      lastChild: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalBorderRadiusCSS)("0 ".concat(euiTheme.border.radius.medium, " ").concat(euiTheme.border.radius.medium, " 0"), true), " clip-path:polygon(\n          0 0,\n          100% 0,\n          100% 100%,\n          0 100%,\n          ", euiTheme.size.s, " 50%\n        );", (0, _global_styling.logicalCSS)('padding-right', euiTheme.size.m), ",;;label:lastChild;")
    }
  };
};
exports.euiBreadcrumbContentStyles = euiBreadcrumbContentStyles;