"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.safariLoadingWorkaround = exports.euiBasicTableBodyLoading = exports.euiBasicTableActionsWrapper = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _templateObject;
function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
var tableLoadingLine = (0, _react.keyframes)(_templateObject || (_templateObject = _taggedTemplateLiteral(["\n  from {\n    ", "\n    ", "\n  }\n\n  20% {\n    ", "\n    ", "\n  }\n\n  80% {\n    ", "\n    ", "\n  }\n\n  100% {\n    ", "\n    ", "\n  }\n"])), (0, _global_styling.logicalCSS)('left', 0), (0, _global_styling.logicalCSS)('width', 0), (0, _global_styling.logicalCSS)('left', 0), (0, _global_styling.logicalCSS)('width', '40%'), (0, _global_styling.logicalCSS)('left', '60%'), (0, _global_styling.logicalCSS)('width', '40%'), (0, _global_styling.logicalCSS)('left', '100%'), (0, _global_styling.logicalCSS)('width', 0));
var euiBasicTableBodyLoading = function euiBasicTableBodyLoading(_ref2) {
  var euiTheme = _ref2.euiTheme;
  return /*#__PURE__*/(0, _react.css)("position:relative;overflow:hidden;&::before{position:absolute;content:'';", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalCSS)('height', euiTheme.border.width.thick), " background-color:", euiTheme.colors.primary, ";animation:", tableLoadingLine, " 1s linear infinite;", _global_styling.euiCantAnimate, "{animation-duration:2s;}};label:euiBasicTableBodyLoading;");
};

// Fix to make the loading indicator position correctly in Safari
// For whatever annoying reason, Safari doesn't respect `position: relative;`
// on `tbody` without `position: relative` on the parent `table`
exports.euiBasicTableBodyLoading = euiBasicTableBodyLoading;
var _ref = process.env.NODE_ENV === "production" ? {
  name: "6xbnw4-safariLoadingWorkaround",
  styles: "position:relative;label:safariLoadingWorkaround;"
} : {
  name: "6xbnw4-safariLoadingWorkaround",
  styles: "position:relative;label:safariLoadingWorkaround;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var safariLoadingWorkaround = function safariLoadingWorkaround() {
  return _ref;
};

// Unsets the extra height caused by tooltip/popover wrappers around table action buttons
// Without this, the row height jumps whenever actions are disabled
exports.safariLoadingWorkaround = safariLoadingWorkaround;
var euiBasicTableActionsWrapper = process.env.NODE_ENV === "production" ? {
  name: "1mshepa-euiBasicTableActionsWrapper",
  styles: "line-height:1;label:euiBasicTableActionsWrapper;"
} : {
  name: "1mshepa-euiBasicTableActionsWrapper",
  styles: "line-height:1;label:euiBasicTableActionsWrapper;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
exports.euiBasicTableActionsWrapper = euiBasicTableActionsWrapper;