"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBadgeColors = exports.euiBetaBadgeStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _services = require("../../../services");
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
var _ref = process.env.NODE_ENV === "production" ? {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;"
} : {
  name: "l1nme7-middle",
  styles: "vertical-align:middle;label:middle;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;"
} : {
  name: "19hexhy-baseline",
  styles: "vertical-align:baseline;label:baseline;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "pzpqqg-euiBetaBadge__icon",
  styles: "position:relative;transform:translate(0, -1px);label:euiBetaBadge__icon;"
} : {
  name: "pzpqqg-euiBetaBadge__icon",
  styles: "position:relative;transform:translate(0, -1px);label:euiBetaBadge__icon;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiBetaBadgeStyles = function euiBetaBadgeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  return {
    euiBetaBadge: /*#__PURE__*/(0, _react.css)("display:inline-block;border-radius:", euiTheme.size.l, ";cursor:default;font-weight:", euiTheme.font.weight.bold, ";text-transform:uppercase;letter-spacing:0.05em;text-align:center;", (0, _global_styling.euiTextTruncate)(), " &:focus{", (0, _global_styling.euiFocusRing)(euiThemeContext, 'outset', {
      color: colorMode === 'DARK' ? euiTheme.colors.ghost : euiTheme.colors.ink
    }), ";};label:euiBetaBadge;"),
    // Colors
    accent: /*#__PURE__*/(0, _react.css)(getBadgeColors(euiTheme.colors.accentText, euiThemeContext), ";;label:accent;"),
    subdued: /*#__PURE__*/(0, _react.css)(getBadgeColors((0, _services.tint)(euiTheme.colors.lightShade, 0.3), euiThemeContext), ";;label:subdued;"),
    hollow: /*#__PURE__*/(0, _react.css)(getBadgeColors(euiTheme.colors.emptyShade, euiThemeContext), " box-shadow:inset 0 0 0 ", euiTheme.border.width.thin, " ", euiTheme.border.color, ";;label:hollow;"),
    // Font sizes
    m: /*#__PURE__*/(0, _react.css)("font-size:", (0, _global_styling.euiFontSizeFromScale)('xs', euiTheme), ";line-height:", euiTheme.size.l, ";;label:m;"),
    s: /*#__PURE__*/(0, _react.css)("font-size:0.625rem;line-height:", (0, _global_styling.mathWithUnits)(euiTheme.size.xs, function (x) {
      return x + euiTheme.base;
    }), ";;label:s;"),
    // Padding/width sizes
    badgeSizes: {
      default: {
        m: "\n        ".concat((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.base)),
        s: "\n        ".concat((0, _global_styling.logicalCSS)('padding-horizontal', euiTheme.size.m))
      },
      // When it's just an icon or a single letter, make the badge a circle
      circle: {
        m: "\n          ".concat((0, _global_styling.logicalCSS)('width', euiTheme.size.l), "\n        "),
        s: "\n          ".concat((0, _global_styling.logicalCSS)('width', (0, _global_styling.mathWithUnits)(euiTheme.size.xs, function (x) {
          return x + euiTheme.base;
        })), "\n        ")
      }
    },
    euiBetaBadge__icon: _ref3,
    // Alignments
    baseline: _ref2,
    middle: _ref
  };
};

// Util for detecting text color based on badge bg color
exports.euiBetaBadgeStyles = euiBetaBadgeStyles;
var getBadgeColors = function getBadgeColors(backgroundColor, _ref4) {
  var euiTheme = _ref4.euiTheme;
  var textColor = _services.isColorDark.apply(void 0, _toConsumableArray((0, _services.hexToRgb)(backgroundColor))) ? euiTheme.colors.ghost : euiTheme.colors.ink;
  return "\n    background-color: ".concat(backgroundColor, ";\n    color: ").concat(textColor, ";\n  ");
};
exports.getBadgeColors = getBadgeColors;