"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiBadgeStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _mixins = require("../../themes/amsterdam/global_styling/mixins");
var _services = require("../../services");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1hw5vc4-clickable",
  styles: "cursor:pointer;label:clickable;"
} : {
  name: "1hw5vc4-clickable",
  styles: "cursor:pointer;label:clickable;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiBadgeStyles = function euiBadgeStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  return {
    euiBadge: /*#__PURE__*/(0, _react.css)("display:inline-block;vertical-align:middle;", (0, _global_styling.logicalShorthandCSS)('padding', "0 ".concat(euiTheme.size.s)), " ", (0, _global_styling.logicalCSS)('max-width', '100%'), " font-size:", (0, _global_styling.euiFontSize)(euiThemeContext, 'xs').fontSize, ";line-height:", euiTheme.base + 2, "px;font-weight:", euiTheme.font.weight.medium, ";white-space:nowrap;text-decoration:none;cursor:default;background-color:transparent;border:", euiTheme.border.width.thin, " solid transparent;border-radius:", (0, _global_styling.mathWithUnits)(euiTheme.border.radius.medium, function (x) {
      return x / 2;
    }), ";", (0, _global_styling.logicalTextAlignCSS)('left'), " &:focus-within{", (0, _global_styling.euiFocusRing)(euiThemeContext), ";}&+.euiBadge{", (0, _global_styling.logicalCSS)('margin-left', euiTheme.size.xs), ";};label:euiBadge;"),
    clickable: /*#__PURE__*/(0, _react.css)("&:not(:disabled){&:hover,&:focus{text-decoration:underline;}}&:focus{", (0, _global_styling.euiFocusRing)(euiThemeContext), ";}&:disabled{cursor:not-allowed;};label:clickable;"),
    disabled: /*#__PURE__*/(0, _react.css)("color:", (0, _mixins.euiButtonColor)(euiThemeContext, 'disabled').color, "!important;background-color:", (0, _mixins.euiButtonColor)(euiThemeContext, 'disabled').backgroundColor, "!important;;label:disabled;"),
    // Hollow has a border and is mostly used for autocompleters.
    hollow: /*#__PURE__*/(0, _react.css)("background-color:", euiTheme.colors.emptyShade, ";border-color:", colorMode === 'DARK' ? (0, _services.tint)(euiTheme.border.color, 0.15) : euiTheme.border.color, ";color:", euiTheme.colors.text, ";;label:hollow;"),
    // Content wrapper
    euiBadge__content: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)(
    // Ensure proper height in case of just displaying an icon
    'min-height', "".concat((0, _global_styling.mathWithUnits)(euiTheme.border.width.thin, function (x) {
      return euiTheme.base + x * 2;
    }))), " display:flex;align-items:center;overflow:hidden;;label:euiBadge__content;"),
    // Text
    text: {
      euiBadge__text: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)(), " cursor:inherit;;label:euiBadge__text;"),
      clickable: _ref
    },
    // Icon
    icon: {
      euiBadge__icon: /*#__PURE__*/(0, _react.css)(";label:euiBadge__icon;"),
      right: /*#__PURE__*/(0, _react.css)("&:not(:only-child){", (0, _global_styling.logicalCSS)('margin-left', euiTheme.size.xs), ";};label:right;"),
      left: /*#__PURE__*/(0, _react.css)("&:not(:only-child){", (0, _global_styling.logicalCSS)('margin-right', euiTheme.size.xs), ";};label:left;")
    },
    // Clickable icons (iconOnClick)
    iconButton: {
      euiBadge__iconButton: /*#__PURE__*/(0, _react.css)("font-size:0;&:focus{background-color:", (0, _services.transparentize)(euiTheme.colors.ghost, 0.8), ";color:", euiTheme.colors.ink, ";border-radius:", (0, _global_styling.mathWithUnits)(euiTheme.border.radius.small, function (x) {
        return x / 2;
      }), ";}&:disabled{cursor:not-allowed;}.euiBadge__icon{margin:0!important;};label:euiBadge__iconButton;"),
      right: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-left', euiTheme.size.xs), ";;label:right;"),
      left: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('margin-right', euiTheme.size.xs), ";;label:left;")
    },
    // Used in badges with both onClick & iconOnClick
    euiBadge__childButton: /*#__PURE__*/(0, _react.css)((0, _global_styling.euiTextTruncate)(), " text-align:inherit;font-weight:inherit;line-height:inherit;color:inherit;&:disabled{cursor:not-allowed;}&:not(:disabled){&:hover,&:focus{text-decoration:underline;}};label:euiBadge__childButton;")
  };
};
exports.euiBadgeStyles = euiBadgeStyles;