"use strict";

var _react = _interopRequireDefault(require("react"));
var _index = require("./index");
var _panel = require("../../components/panel");
var _services = require("../../services");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

var baseProps = {
  buttonContent: 'Click me to toggle',
  id: (0, _services.htmlIdGenerator)()(),
  initialIsOpen: false
};
var noArrow = {
  arrowDisplay: 'none'
};
var noArrowProps = Object.assign(baseProps, noArrow);
describe('EuiAccordion', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations when expanded', function () {
      cy.mount((0, _react2.jsx)(_index.EuiAccordion, noArrowProps, (0, _react2.jsx)(_panel.EuiPanel, {
        color: "subdued"
      }, "Any content inside of ", (0, _react2.jsx)("strong", null, "EuiAccordion"), " will appear here. We will include ", (0, _react2.jsx)("a", {
        href: "#"
      }, "a link"), " to confirm focus.")));
      cy.get('button.euiAccordion__button').click();
      cy.checkAxe();
    });
  });
});