"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POSITIONS = exports.EuiSkipLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _tabbable = require("tabbable");
var _services = require("../../../services");
var _button = require("../../button/button");
var _screen_reader_only = require("../screen_reader_only");
var _skip_link = require("./skip_link.styles");
var _react2 = require("@emotion/react");
var _excluded = ["destinationId", "fallbackDestination", "overrideLinkBehavior", "tabIndex", "position", "children", "className", "onClick"];
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
var POSITIONS = ['static', 'fixed', 'absolute'];
exports.POSITIONS = POSITIONS;
var EuiSkipLink = function EuiSkipLink(_ref) {
  var destinationId = _ref.destinationId,
    _ref$fallbackDestinat = _ref.fallbackDestination,
    fallbackDestination = _ref$fallbackDestinat === void 0 ? 'main' : _ref$fallbackDestinat,
    overrideLinkBehavior = _ref.overrideLinkBehavior,
    tabIndex = _ref.tabIndex,
    _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'static' : _ref$position,
    children = _ref.children,
    className = _ref.className,
    _onClick = _ref.onClick,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _skip_link.euiSkipLinkStyles)(euiTheme);
  var classes = (0, _classnames.default)('euiSkipLink', className);
  var cssStyles = [styles.euiSkipLink, position !== 'static' ? styles[position] : undefined];
  var onClick = (0, _react.useCallback)(function (e) {
    var destinationEl = null;
    // Check if the destination ID is valid
    destinationEl = document.getElementById(destinationId);
    var hasValidId = !!destinationEl;
    // Check the fallback destination if not
    if (!destinationEl && fallbackDestination) {
      if (Array.isArray(fallbackDestination)) {
        for (var i = 0; i < fallbackDestination.length; i++) {
          destinationEl = document.querySelector(fallbackDestination[i]);
          if (destinationEl) break; // Stop once the first fallback has been found
        }
      } else {
        destinationEl = document.querySelector(fallbackDestination);
      }
    }
    if ((overrideLinkBehavior || !hasValidId) && destinationEl) {
      e.preventDefault();

      // Scroll to the top of the destination content only if it's ~mostly out of view
      var destinationY = destinationEl.getBoundingClientRect().top;
      var halfOfViewportHeight = window.innerHeight / 2;
      if (destinationY >= halfOfViewportHeight || window.scrollY >= destinationY + halfOfViewportHeight) {
        destinationEl.scrollIntoView();
      }

      // Ensure the destination content is focusable
      if (!(0, _tabbable.isTabbable)(destinationEl)) {
        destinationEl.tabIndex = -1;
        destinationEl.addEventListener('blur', function () {
          var _destinationEl;
          return (_destinationEl = destinationEl) === null || _destinationEl === void 0 ? void 0 : _destinationEl.removeAttribute('tabindex');
        }, {
          once: true
        });
      }
      destinationEl.focus({
        preventScroll: true
      }); // Scrolling is already handled above, and focus autoscroll behaves oddly on Chrome around fixed headers
    }

    _onClick === null || _onClick === void 0 ? void 0 : _onClick(e);
  }, [overrideLinkBehavior, destinationId, fallbackDestination, _onClick]);
  return (0, _react2.jsx)(_screen_reader_only.EuiScreenReaderOnly, {
    showOnFocus: true
  }, (0, _react2.jsx)(_button.EuiButton, _extends({
    css: cssStyles,
    className: classes,
    tabIndex: position === 'fixed' ? 0 : tabIndex,
    size: "s",
    fill: true,
    href: "#".concat(destinationId),
    onClick: onClick
  }, rest), children));
};
exports.EuiSkipLink = EuiSkipLink;
EuiSkipLink.propTypes = {
  href: _propTypes.default.string,
  onClick: _propTypes.default.func,
  /**
     * Change the display position of the element when focused.
     * If 'fixed', the link will be fixed to the top left of the viewport
     */
  position: _propTypes.default.any,
  /**
     * Typically an anchor id (e.g. `a11yMainContent`), the value provided
     * will be prepended with a hash `#` and used as the link `href`
     */
  destinationId: _propTypes.default.string.isRequired,
  /**
     * If no destination ID element exists or can be found, you may provide a query selector
     * string to fall back to.
     *
     * For complex applications with potentially variable layouts per page, an array of
     * query selectors can be passed, e.g. `['main', '[role=main]', '.appWrapper']`, which
     * prioritizes looking for multiple fallbacks based on array order.
     * @default main
     */
  fallbackDestination: _propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired]),
  /**
     * If default HTML anchor link behavior is not desired (e.g. for SPAs with hash routing),
     * setting this flag to true will manually scroll to and focus the destination element
     * without changing the browser URL's hash
     */
  overrideLinkBehavior: _propTypes.default.bool,
  /**
     * When position is fixed, this is forced to `0`
     */
  tabIndex: _propTypes.default.number,
  children: _propTypes.default.node,
  /**
     * Make button a solid color for prominence
     */
  fill: _propTypes.default.bool,
  /**
     * Any of the named color palette options.
     * **`'ghost'` is set for deprecation. Use EuiThemeProvide.colorMode = 'dark' instead.**
     */
  color: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.oneOf(["ghost"])]),
  /**
     * Use size `s` in confined spaces
     */
  size: _propTypes.default.any,
  /**
     * `disabled` is also allowed
     */
  isDisabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  buttonRef: _propTypes.default.any
};