"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiScreenReaderLive = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _screen_reader_only = require("../screen_reader_only");
var _react2 = require("@emotion/react");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i.return && (_r = _i.return(), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
var EuiScreenReaderLive = function EuiScreenReaderLive(_ref) {
  var children = _ref.children,
    _ref$isActive = _ref.isActive,
    isActive = _ref$isActive === void 0 ? true : _ref$isActive,
    _ref$role = _ref.role,
    role = _ref$role === void 0 ? 'status' : _ref$role,
    _ref$ariaLive = _ref['aria-live'],
    ariaLive = _ref$ariaLive === void 0 ? 'polite' : _ref$ariaLive,
    _ref$focusRegionOnTex = _ref.focusRegionOnTextChange,
    focusRegionOnTextChange = _ref$focusRegionOnTex === void 0 ? false : _ref$focusRegionOnTex;
  var _useState = (0, _react.useState)(false),
    _useState2 = _slicedToArray(_useState, 2),
    toggle = _useState2[0],
    setToggle = _useState2[1];
  var focusRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(function () {
    setToggle(function (toggle) {
      return !toggle;
    });
  }, [children]);
  (0, _react.useEffect)(function () {
    if (focusRef.current !== null && focusRegionOnTextChange) {
      focusRef.current.focus();
    }
  }, [toggle, focusRegionOnTextChange]);
  return (
    /**
     * Intentionally uses two persistent live regions with oscillating content updates.
     * This resolves the problem of duplicate screen reader announcements in rapid succession
     * caused by React's virtual DOM behaviour (https://github.com/nvaccess/nvda/issues/7996#issuecomment-413641709)
     *
     * Adapted from https://github.com/alphagov/accessible-autocomplete/blob/a7106f03150941fc15e6c1ceb0a90e8872fa86ef/src/status.js
     * Debouncing was not needed for this case, but could prove to be useful for future use cases.
     * See also https://github.com/AlmeroSteyn/react-aria-live and https://github.com/dequelabs/ngA11y
     * for more examples of the double region approach.
     */
    (0, _react2.jsx)(_screen_reader_only.EuiScreenReaderOnly, null, (0, _react2.jsx)("div", {
      ref: focusRef,
      tabIndex: focusRegionOnTextChange ? -1 : undefined
    }, (0, _react2.jsx)("div", {
      role: role,
      "aria-atomic": "true"
      // Setting `aria-hidden` and setting `aria-live` to "off" prevents
      // double announcements from VO when `focusRegionOnTextChange` is true
      ,
      "aria-hidden": toggle ? undefined : 'true',
      "aria-live": !toggle || focusRegionOnTextChange ? 'off' : ariaLive
    }, isActive && toggle ? children : ''), (0, _react2.jsx)("div", {
      role: role,
      "aria-atomic": "true",
      "aria-hidden": !toggle ? undefined : 'true',
      "aria-live": toggle || focusRegionOnTextChange ? 'off' : ariaLive
    }, isActive && !toggle ? children : '')))
  );
};
exports.EuiScreenReaderLive = EuiScreenReaderLive;
EuiScreenReaderLive.propTypes = {
  /**
     * Whether to make screen readers aware of the content
     */
  isActive: _propTypes.default.bool,
  /**
     * Content for screen readers to announce
     */
  children: _propTypes.default.node,
  /**
     * `role` attribute for both live regions.
     *
     * https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Live_Regions#roles_with_implicit_live_region_attributes
     */
  role: _propTypes.default.any,
  /**
     * `aria-live` attribute for both live regions
     */
  "aria-live": _propTypes.default.any,
  /**
     * On `children`/text change, the region will auto-focus itself, causing screen readers
     * to automatically read out the text content. This prop should primarily be used for
     * navigation or page changes, where programmatically resetting focus location back to
     * a certain part of the page is desired.
     */
  focusRegionOnTextChange: _propTypes.default.bool
};