"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isExternalTooltipVisibleSelector = void 0;
var get_internal_main_projection_area_1 = require("./get_internal_main_projection_area");
var get_settings_spec_1 = require("./get_settings_spec");
var has_external_pointer_event_1 = require("./has_external_pointer_event");
var get_computed_scales_1 = require("../../chart_types/xy_chart/state/selectors/get_computed_scales");
var specs_1 = require("../../specs");
var common_1 = require("../../utils/common");
var create_selector_1 = require("../create_selector");
var getExternalEventPointer = function (_a) {
    var pointer = _a.externalEvents.pointer;
    return pointer;
};
exports.isExternalTooltipVisibleSelector = (0, create_selector_1.createCustomCachedSelector)([
    get_settings_spec_1.getSettingsSpecSelector,
    has_external_pointer_event_1.hasExternalEventSelector,
    getExternalEventPointer,
    get_computed_scales_1.getComputedScalesSelector,
    get_internal_main_projection_area_1.getInternalMainProjectionAreaSelector,
], function (_a, hasExternalEvent, pointer, _b, chartDimensions) {
    var _c, _d;
    var externalPointerEvents = _a.externalPointerEvents;
    var xScale = _b.xScale;
    if (!pointer ||
        pointer.type !== specs_1.PointerEventType.Over ||
        (0, common_1.isNil)(pointer.x) ||
        ((_c = externalPointerEvents.tooltip) === null || _c === void 0 ? void 0 : _c.visible) === false) {
        return false;
    }
    var x = xScale.pureScale(pointer.x);
    if (Number.isNaN(x) || x > chartDimensions.width + chartDimensions.left || x < 0) {
        return false;
    }
    return Boolean(hasExternalEvent && ((_d = externalPointerEvents.tooltip) === null || _d === void 0 ? void 0 : _d.visible));
});
//# sourceMappingURL=is_external_tooltip_visible.js.map