"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getScale = exports.computeSmallMultipleScalesSelector = void 0;
var get_internal_main_projection_area_1 = require("./get_internal_main_projection_area");
var get_internal_sm_domains_1 = require("./get_internal_sm_domains");
var get_small_multiples_spec_1 = require("./get_small_multiples_spec");
var scales_1 = require("../../scales");
var specs_1 = require("../../specs");
var create_selector_1 = require("../create_selector");
exports.computeSmallMultipleScalesSelector = (0, create_selector_1.createCustomCachedSelector)([get_internal_sm_domains_1.getInternalSmallMultiplesDomains, get_internal_main_projection_area_1.getInternalMainProjectionAreaSelector, get_small_multiples_spec_1.getSmallMultiplesSpec], function (_a, _b, smSpec) {
    var _c, _d;
    var smHDomain = _a.smHDomain, smVDomain = _a.smVDomain;
    var width = _b.width, height = _b.height;
    return {
        horizontal: getScale(smHDomain, width, (_c = smSpec === null || smSpec === void 0 ? void 0 : smSpec.style) === null || _c === void 0 ? void 0 : _c.horizontalPanelPadding),
        vertical: getScale(smVDomain, height, (_d = smSpec === null || smSpec === void 0 ? void 0 : smSpec.style) === null || _d === void 0 ? void 0 : _d.verticalPanelPadding),
    };
});
function getScale(domain, maxRange, padding) {
    if (padding === void 0) { padding = specs_1.DEFAULT_SM_PANEL_PADDING; }
    var singlePanelSmallMultiple = domain.length <= 1;
    return new scales_1.ScaleBand(domain, [0, maxRange], undefined, singlePanelSmallMultiple ? 0 : padding);
}
exports.getScale = getScale;
//# sourceMappingURL=compute_small_multiple_scales.js.map