"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPinnableTooltip = void 0;
var get_tooltip_spec_1 = require("./get_tooltip_spec");
var is_external_tooltip_visible_1 = require("./is_external_tooltip_visible");
var chart_types_1 = require("../../chart_types");
var get_tooltip_values_highlighted_geoms_1 = require("../../chart_types/xy_chart/state/selectors/get_tooltip_values_highlighted_geoms");
var create_selector_1 = require("../create_selector");
var pinnableTooltipCharts = new Set([
    chart_types_1.ChartType.XYAxis,
    chart_types_1.ChartType.Heatmap,
    chart_types_1.ChartType.Partition,
    chart_types_1.ChartType.Flame,
]);
var getChartType = function (_a) {
    var chartType = _a.chartType;
    return chartType;
};
exports.isPinnableTooltip = (0, create_selector_1.createCustomCachedSelector)([getChartType, is_external_tooltip_visible_1.isExternalTooltipVisibleSelector, get_tooltip_spec_1.getTooltipSpecSelector, get_tooltip_values_highlighted_geoms_1.getTooltipInfoAndGeomsSelector], function (chartType, isExternal, _a, _b) {
    var maxVisibleTooltipItems = _a.maxVisibleTooltipItems, maxTooltipItems = _a.maxTooltipItems, actions = _a.actions;
    var tooltip = _b.tooltip, highlightedGeometries = _b.highlightedGeometries;
    var isPinnableChartType = Boolean(chartType && pinnableTooltipCharts.has(chartType));
    var actionable = actions.length > 0 || !Array.isArray(actions);
    var hasHiddenSeries = false;
    if (chartType === chart_types_1.ChartType.XYAxis) {
        var infoCount = tooltip.values.length;
        var highlightCount = highlightedGeometries.length;
        hasHiddenSeries =
            (infoCount > highlightCount && infoCount > maxTooltipItems) || infoCount > maxVisibleTooltipItems;
    }
    return isPinnableChartType && !isExternal && (hasHiddenSeries || actionable);
});
//# sourceMappingURL=can_pin_tooltip.js.map