"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TooltipWrapper = void 0;
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importStar(require("react"));
var tooltip_actions_1 = require("./tooltip_actions");
var tooltip_prompt_1 = require("./tooltip_prompt");
var tooltip_provider_1 = require("./tooltip_provider");
var TooltipWrapper = function (_a) {
    var children = _a.children, className = _a.className, actions = _a.actions, actionPrompt = _a.actionPrompt, pinningPrompt = _a.pinningPrompt, selectionPrompt = _a.selectionPrompt, actionsLoading = _a.actionsLoading, noActionsLoaded = _a.noActionsLoaded;
    var _b = (0, tooltip_provider_1.useTooltipContext)(), dir = _b.dir, pinned = _b.pinned, canPinTooltip = _b.canPinTooltip, selected = _b.selected, theme = _b.theme, actionable = _b.actionable;
    var tooltipRef = (0, react_1.useRef)(null);
    var _c = __read((0, react_1.useState)(0), 2), minWidth = _c[0], setMinWidth = _c[1];
    (0, react_1.useEffect)(function () {
        window.requestAnimationFrame(function () {
            if (tooltipRef.current) {
                var width = tooltipRef.current.getBoundingClientRect().width;
                setMinWidth(width);
            }
        });
    }, []);
    (0, react_1.useEffect)(function () {
        if (pinned && tooltipRef.current && typeof theme.maxWidth === 'number' && minWidth < theme.maxWidth) {
            var width = tooltipRef.current.getBoundingClientRect().width;
            if (width > minWidth)
                setMinWidth(width);
        }
    }, [selected, pinned, minWidth, theme.maxWidth]);
    return (react_1.default.createElement("div", { className: (0, classnames_1.default)('echTooltip', className, { 'echTooltip--pinned': pinned }), dir: dir, ref: tooltipRef, style: { minWidth: minWidth }, onClick: function (e) { return e.stopPropagation(); }, onKeyPress: function (e) { return e.stopPropagation(); } },
        children,
        !canPinTooltip ? null : pinned ? (react_1.default.createElement(tooltip_actions_1.TooltipActions, { actions: actions, actionsLoading: actionsLoading, noActionsLoaded: noActionsLoaded, selectionPrompt: selectionPrompt })) : (react_1.default.createElement(tooltip_prompt_1.TooltipPrompt, null, actionable ? actionPrompt : pinningPrompt))));
};
exports.TooltipWrapper = TooltipWrapper;
//# sourceMappingURL=tooltip_wrapper.js.map