"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.computeTableMaxHeight = exports.TooltipTable = void 0;
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importDefault(require("react"));
var tooltip_provider_1 = require("./tooltip_provider");
var tooltip_table_body_1 = require("./tooltip_table_body");
var tooltip_table_footer_1 = require("./tooltip_table_footer");
var tooltip_table_header_1 = require("./tooltip_table_header");
var common_1 = require("../../../utils/common");
var TOOLTIP_ITEM_HEIGHT = 20;
var TOOLTIP_HEADER_HEIGHT = 25;
var TOOLTIP_FOOTER_HEIGHT = 25;
var MAX_ROW_COLOR_STRIP_WIDTH = 11;
var TooltipTable = function (_a) {
    var _b;
    var className = _a.className, props = __rest(_a, ["className"]);
    var tooltipContext = (0, tooltip_provider_1.useTooltipContext)();
    var pinned = (_b = props.pinned) !== null && _b !== void 0 ? _b : tooltipContext.pinned;
    var wrapperClasses = (0, classnames_1.default)('echTooltip__tableWrapper', { 'echTooltip__tableWrapper--pinned': pinned });
    if ('children' in props) {
        var gridTemplateColumns_1 = props.gridTemplateColumns, maxHeight = props.maxHeight;
        var classes = (0, classnames_1.default)('echTooltip__table', className, {
            'echTooltip__table--noGrid': !gridTemplateColumns_1,
        });
        return (react_1.default.createElement("div", { className: wrapperClasses, style: { maxHeight: maxHeight } },
            react_1.default.createElement("div", { role: "table", className: classes, style: { gridTemplateColumns: gridTemplateColumns_1 } }, props.children)));
    }
    var _c = __assign({ selected: tooltipContext.selected }, props), items = _c.items, onSelect = _c.onSelect, _d = _c.selected, selected = _d === void 0 ? [] : _d;
    var columns = props.columns.filter(function (_a) {
        var _b;
        var hidden = _a.hidden;
        return !(typeof hidden === 'boolean' ? hidden : (_b = hidden === null || hidden === void 0 ? void 0 : hidden(props.items)) !== null && _b !== void 0 ? _b : false);
    });
    var gridTemplateColumns = columns
        .map(function (_a) {
        var type = _a.type, width = _a.width;
        return width !== null && width !== void 0 ? width : (type === 'color' ? MAX_ROW_COLOR_STRIP_WIDTH : 'auto');
    })
        .map(function (width) { return (typeof width === 'number' ? "".concat(width, "px") : width); })
        .join(' ');
    return (react_1.default.createElement("div", { className: wrapperClasses, style: { maxHeight: props.maxHeight } },
        react_1.default.createElement("div", { role: "table", className: (0, classnames_1.default)('echTooltip__table', className), style: { gridTemplateColumns: gridTemplateColumns } },
            react_1.default.createElement(tooltip_table_header_1.TooltipTableHeader, { columns: columns, items: props.items }),
            react_1.default.createElement(tooltip_table_body_1.TooltipTableBody, { columns: columns, items: items, pinned: pinned, onSelect: onSelect, selected: selected }),
            react_1.default.createElement(tooltip_table_footer_1.TooltipTableFooter, { columns: columns, items: props.items }))));
};
exports.TooltipTable = TooltipTable;
function computeTableMaxHeight(pinned, columns, maxHeight, maxItems) {
    if (pinned || (0, common_1.isNil)(maxItems))
        return maxHeight;
    var headerHeight = +columns.some(function (c) { return c.header; }) * TOOLTIP_HEADER_HEIGHT;
    var bodyHeight = (Math.max(maxItems, 1) + 0.5) * TOOLTIP_ITEM_HEIGHT;
    var footerHeight = +columns.some(function (c) { return c.footer; }) * TOOLTIP_FOOTER_HEIGHT;
    return headerHeight + bodyHeight + footerHeight;
}
exports.computeTableMaxHeight = computeTableMaxHeight;
//# sourceMappingURL=tooltip_table.js.map