"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Legend = void 0;
var classnames_1 = __importDefault(require("classnames"));
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var custom_legend_1 = require("./custom_legend");
var legend_item_1 = require("./legend_item");
var position_style_1 = require("./position_style");
var style_utils_1 = require("./style_utils");
var specs_1 = require("../../specs");
var colors_1 = require("../../state/actions/colors");
var legend_1 = require("../../state/actions/legend");
var get_chart_theme_1 = require("../../state/selectors/get_chart_theme");
var get_internal_is_intialized_1 = require("../../state/selectors/get_internal_is_intialized");
var get_internal_main_projection_area_1 = require("../../state/selectors/get_internal_main_projection_area");
var get_internal_projection_container_area_1 = require("../../state/selectors/get_internal_projection_container_area");
var get_legend_config_selector_1 = require("../../state/selectors/get_legend_config_selector");
var get_legend_items_1 = require("../../state/selectors/get_legend_items");
var get_legend_items_values_1 = require("../../state/selectors/get_legend_items_values");
var get_legend_size_1 = require("../../state/selectors/get_legend_size");
var get_settings_spec_1 = require("../../state/selectors/get_settings_spec");
var common_1 = require("../../utils/common");
var light_theme_1 = require("../../utils/themes/light_theme");
function LegendComponent(props) {
    var _a;
    var items = props.items, size = props.size, debug = props.debug, isBrushing = props.isBrushing, _b = props.chartTheme, chartMargins = _b.chartMargins, legend = _b.legend, chartDimensions = props.chartDimensions, containerDimensions = props.containerDimensions, config = props.config;
    if (items.every(function (_a) {
        var isItemHidden = _a.isItemHidden;
        return isItemHidden;
    })) {
        return null;
    }
    var positionConfig = (0, position_style_1.getLegendPositionConfig)(config.legendPosition);
    var containerStyle = (0, style_utils_1.getLegendStyle)(positionConfig, size, legend.margin);
    var listStyle = (0, style_utils_1.getLegendListStyle)(positionConfig, chartMargins, legend, items.length);
    var isMostlyRTL = (0, common_1.hasMostlyRTLItems)(items.map(function (_a) {
        var label = _a.label;
        return label;
    }));
    var legendClasses = (0, classnames_1.default)('echLegend', {
        'echLegend--debug': debug,
        'echLegend--inert': isBrushing,
        'echLegend--horizontal': positionConfig.direction === common_1.LayoutDirection.Horizontal,
        'echLegend--vertical': positionConfig.direction === common_1.LayoutDirection.Vertical,
        'echLegend--left': positionConfig.hAlign === common_1.HorizontalAlignment.Left,
        'echLegend--right': positionConfig.hAlign === common_1.HorizontalAlignment.Right,
        'echLegend--top': positionConfig.vAlign === common_1.VerticalAlignment.Top,
        'echLegend--bottom': positionConfig.vAlign === common_1.VerticalAlignment.Bottom,
    });
    var itemProps = {
        positionConfig: positionConfig,
        isMostlyRTL: isMostlyRTL,
        totalItems: items.length,
        extraValues: props.extraValues,
        showExtra: config.showLegendExtra,
        onMouseOut: config.onLegendItemOut,
        onMouseOver: config.onLegendItemOver,
        onClick: config.onLegendItemClick,
        clearTemporaryColorsAction: props.clearTemporaryColors,
        setPersistedColorAction: props.setPersistedColor,
        setTemporaryColorAction: props.setTemporaryColor,
        mouseOutAction: props.onItemOutAction,
        mouseOverAction: props.onItemOverAction,
        toggleDeselectSeriesAction: props.onToggleDeselectSeriesAction,
        colorPicker: config.legendColorPicker,
        action: config.legendAction,
        labelOptions: legend.labelOptions,
        flatLegend: (_a = config.flatLegend) !== null && _a !== void 0 ? _a : specs_1.DEFAULT_LEGEND_CONFIG.flatLegend,
    };
    var positionStyle = (0, position_style_1.legendPositionStyle)(config, size, chartDimensions, containerDimensions);
    return (react_1.default.createElement("div", { className: legendClasses, style: positionStyle, dir: isMostlyRTL ? 'rtl' : 'ltr' }, config.customLegend ? (react_1.default.createElement("div", { style: containerStyle },
        react_1.default.createElement(custom_legend_1.CustomLegend, { component: config.customLegend, items: items.map(function (_a) {
                var _b;
                var seriesIdentifiers = _a.seriesIdentifiers, childId = _a.childId, path = _a.path, customProps = __rest(_a, ["seriesIdentifiers", "childId", "path"]);
                return (__assign(__assign({}, customProps), { seriesIdentifiers: seriesIdentifiers, path: path, extraValue: (_b = itemProps.extraValues.get(seriesIdentifiers[0].key)) === null || _b === void 0 ? void 0 : _b.get(childId || ''), onItemOutAction: itemProps.mouseOutAction, onItemOverActon: function () { return itemProps.mouseOverAction(path); }, onItemClickAction: function (negate) { return itemProps.toggleDeselectSeriesAction(seriesIdentifiers, negate); } }));
            }) }))) : (react_1.default.createElement("div", { style: containerStyle, className: "echLegendListContainer" },
        react_1.default.createElement("ul", { style: listStyle, className: "echLegendList" }, items.map(function (item, index) { return (react_1.default.createElement(legend_item_1.LegendListItem, __assign({ key: "".concat(index), item: item }, itemProps))); }))))));
}
var mapDispatchToProps = function (dispatch) {
    return (0, redux_1.bindActionCreators)({
        onToggleDeselectSeriesAction: legend_1.onToggleDeselectSeriesAction,
        onItemOutAction: legend_1.onLegendItemOutAction,
        onItemOverAction: legend_1.onLegendItemOverAction,
        clearTemporaryColors: colors_1.clearTemporaryColors,
        setTemporaryColor: colors_1.setTemporaryColor,
        setPersistedColor: colors_1.setPersistedColor,
    }, dispatch);
};
var EMPTY_DEFAULT_STATE = {
    chartDimensions: { width: 0, height: 0, left: 0, top: 0 },
    containerDimensions: { width: 0, height: 0, left: 0, top: 0 },
    items: [],
    extraValues: new Map(),
    debug: false,
    isBrushing: false,
    chartTheme: light_theme_1.LIGHT_THEME,
    size: { width: 0, height: 0 },
    config: specs_1.DEFAULT_LEGEND_CONFIG,
};
var mapStateToProps = function (state) {
    if ((0, get_internal_is_intialized_1.getInternalIsInitializedSelector)(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return EMPTY_DEFAULT_STATE;
    }
    var config = (0, get_legend_config_selector_1.getLegendConfigSelector)(state);
    if (!config.showLegend) {
        return EMPTY_DEFAULT_STATE;
    }
    var debug = (0, get_settings_spec_1.getSettingsSpecSelector)(state).debug;
    return {
        debug: debug,
        isBrushing: state.interactions.pointer.dragging,
        chartDimensions: (0, get_internal_main_projection_area_1.getInternalMainProjectionAreaSelector)(state),
        containerDimensions: (0, get_internal_projection_container_area_1.getInternalProjectionContainerAreaSelector)(state),
        chartTheme: (0, get_chart_theme_1.getChartThemeSelector)(state),
        size: (0, get_legend_size_1.getLegendSizeSelector)(state),
        items: (0, get_legend_items_1.getLegendItemsSelector)(state),
        extraValues: (0, get_legend_items_values_1.getLegendExtraValuesSelector)(state),
        config: config,
    };
};
exports.Legend = (0, react_redux_1.connect)(mapStateToProps, mapDispatchToProps)(LegendComponent);
//# sourceMappingURL=legend.js.map