"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isPointerInsideChart = exports.isPointerOverPanelFn = exports.getPanelTitle = exports.hasSMDomain = exports.getPanelSize = exports.getPerPanelMap = void 0;
var common_1 = require("../utils/common");
function getPerPanelMap(scales, fn) {
    var horizontal = scales.horizontal, vertical = scales.vertical;
    return vertical.domain.reduce(function (acc, verticalValue) {
        return __spreadArray(__spreadArray([], __read(acc), false), __read(horizontal.domain.reduce(function (hAcc, horizontalValue) {
            var panelAnchor = {
                x: horizontal.scale(horizontalValue) || 0,
                y: vertical.scale(verticalValue) || 0,
            };
            var fnReturn = fn(panelAnchor, horizontalValue, verticalValue, scales);
            return fnReturn ? __spreadArray(__spreadArray([], __read(hAcc), false), [__assign({ panelAnchor: panelAnchor, horizontalValue: horizontalValue, verticalValue: verticalValue }, fnReturn)], false) : hAcc;
        }, [])), false);
    }, []);
}
exports.getPerPanelMap = getPerPanelMap;
function getPanelSize(_a) {
    var horizontal = _a.horizontal, vertical = _a.vertical;
    return { width: horizontal.bandwidth, height: vertical.bandwidth };
}
exports.getPanelSize = getPanelSize;
var hasSMDomain = function (_a) {
    var domain = _a.domain;
    return domain.length > 0 && domain[0] !== undefined;
};
exports.hasSMDomain = hasSMDomain;
var getPanelTitle = function (isVertical, verticalValue, horizontalValue, groupBy) {
    var _a, _b;
    return isVertical
        ? (0, common_1.safeFormat)("".concat(verticalValue), (_a = groupBy === null || groupBy === void 0 ? void 0 : groupBy.vertical) === null || _a === void 0 ? void 0 : _a.format)
        : (0, common_1.safeFormat)("".concat(horizontalValue), (_b = groupBy === null || groupBy === void 0 ? void 0 : groupBy.horizontal) === null || _b === void 0 ? void 0 : _b.format);
};
exports.getPanelTitle = getPanelTitle;
var isPointerOverPanelFn = function (smScales, chartDimensions, gridStroke) {
    return function (pointer) {
        return ((0, exports.isPointerInsideChart)(chartDimensions)(pointer) &&
            isPointerInBandwidth(smScales.horizontal, pointer.x - chartDimensions.left, gridStroke) &&
            isPointerInBandwidth(smScales.vertical, pointer.y - chartDimensions.top, gridStroke));
    };
};
exports.isPointerOverPanelFn = isPointerOverPanelFn;
function isPointerInBandwidth(scale, dimension, gridStroke) {
    var bandwidth = scale.bandwidth, innerPadding = scale.innerPadding;
    var padding = innerPadding * bandwidth;
    var divisor = bandwidth + padding + gridStroke * 2;
    var vDiv = Math.floor(dimension / divisor);
    var lower = vDiv * divisor;
    var upper = lower + bandwidth + gridStroke * 2;
    return dimension > lower && dimension <= upper;
}
var isPointerInsideChart = function (_a) {
    var left = _a.left, top = _a.top, height = _a.height, width = _a.width;
    return function (_a) {
        var x = _a.x, y = _a.y;
        return x > left && x < left + width && y > top && y < top + height;
    };
};
exports.isPointerInsideChart = isPointerInsideChart;
//# sourceMappingURL=panel_utils.js.map