"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.numericalRasters = void 0;
var axis_model_1 = require("../../../timeslip/projections/axis_model");
var numericalLayerCount = 2;
var numericalRasters = function (_a) {
    var minimumTickPixelDistance = _a.minimumTickPixelDistance, locale = _a.locale;
    var numberFormatter = new Intl.NumberFormat(locale, {
        notation: 'standard',
        maximumFractionDigits: 0,
    });
    var format = function (value) { return numberFormatter.format(value); };
    var allRasters = __spreadArray([], __read(new Array(numericalLayerCount)), false).map(function (_, i) { return ({
        unit: 'one',
        unitMultiplier: Infinity,
        labeled: i === 0,
        minimumTickPixelDistance: minimumTickPixelDistance,
        intervals: function (domainFrom, domainTo) {
            return (0, axis_model_1.getDecimalTicks)(domainFrom, domainTo, i === 0 ? 20 : 5, axis_model_1.oneFive).map(function (d, i, a) { return ({
                minimum: d,
                supremum: i < a.length - 1 ? a[i + 1] : d + (d - a[i - 1]),
            }); });
        },
        detailedLabelFormat: function (n) { return format((n - 1300000000000) / 1e6); },
        minorTickLabelFormat: function (n) { return format((n - 1300000000000) / 1e6); },
    }); })
        .reverse();
    return function (filter) {
        var e_1, _a;
        var layers = new Set();
        try {
            for (var allRasters_1 = __values(allRasters), allRasters_1_1 = allRasters_1.next(); !allRasters_1_1.done; allRasters_1_1 = allRasters_1.next()) {
                var layer = allRasters_1_1.value;
                if (filter(layer))
                    layers.add(layer);
                else
                    break;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (allRasters_1_1 && !allRasters_1_1.done && (_a = allRasters_1.return)) _a.call(allRasters_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return __spreadArray([], __read(layers), false).reverse();
    };
};
exports.numericalRasters = numericalRasters;
//# sourceMappingURL=numerical_rasters.js.map