"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.multilayerAxisEntry = exports.notTooDense = exports.MINIMUM_TICK_PIXEL_DISTANCE = exports.DEFAULT_LOCALE = exports.MAX_TIME_GRID_COUNT = exports.MAX_TIME_TICK_COUNT = void 0;
var continuous_time_rasters_1 = require("./continuous_time_rasters");
var WIDTH_FUDGE = 1.05;
exports.MAX_TIME_TICK_COUNT = 50;
exports.MAX_TIME_GRID_COUNT = 12;
exports.DEFAULT_LOCALE = 'en-US';
exports.MINIMUM_TICK_PIXEL_DISTANCE = 24;
var notTooDense = function (domainFrom, domainTo, intervalWidth, cartesianWidth, maxTickCount) {
    return function (_a) {
        var unit = _a.unit, unitMultiplier = _a.unitMultiplier, minimumTickPixelDistance = _a.minimumTickPixelDistance;
        var domainSize = domainTo - domainFrom;
        var partitionIntervalWidth = continuous_time_rasters_1.unitIntervalWidth[unit] * unitMultiplier;
        var maximumTickCount = Math.min(maxTickCount, cartesianWidth / minimumTickPixelDistance);
        var tickCountConstraint = domainSize / maximumTickCount;
        var spacingConstraint = intervalWidth / WIDTH_FUDGE;
        return partitionIntervalWidth >= Math.max(tickCountConstraint, spacingConstraint);
    };
};
exports.notTooDense = notTooDense;
function multilayerAxisEntry(xDomain, extendByOneBin, range, timeAxisLayerCount, scale, getMeasuredTicks) {
    var rasterSelector = (0, continuous_time_rasters_1.continuousTimeRasters)({ minimumTickPixelDistance: exports.MINIMUM_TICK_PIXEL_DISTANCE, locale: exports.DEFAULT_LOCALE }, xDomain.timeZone);
    var domainValues = xDomain.domain;
    var domainFromS = Number(domainValues[0]) / 1000;
    var binWidthMs = xDomain.minInterval;
    var binWidth = binWidthMs / 1000;
    var domainExtension = extendByOneBin ? binWidthMs : 0;
    var domainToS = ((Number(domainValues[domainValues.length - 1]) || NaN) + domainExtension) / 1000;
    var cartesianWidth = Math.abs(range[1] - range[0]);
    var layers = rasterSelector((0, exports.notTooDense)(domainFromS, domainToS, binWidth, cartesianWidth, exports.MAX_TIME_TICK_COUNT));
    var layerIndex = -1;
    var fillLayerTimeslip = function (layer, detailedLayer, timeTicks, labelFormat, showGrid) {
        return {
            entry: getMeasuredTicks(scale, timeTicks, layer, detailedLayer, labelFormat, showGrid),
            fallbackAskedTickCount: NaN,
        };
    };
    var binStartsFrom = domainFromS - binWidth;
    var binStartsTo = domainToS + binWidth;
    return layers.reduce(function (combinedEntry, l, detailedLayerIndex) {
        if (l.labeled)
            layerIndex++;
        if (layerIndex >= timeAxisLayerCount)
            return combinedEntry;
        var timeTicks = __spreadArray([], __read(l.intervals(binStartsFrom, binStartsTo)), false).filter(function (b) { return b.supremum > domainFromS && b.minimum <= domainToS; })
            .map(function (b) { return 1000 * b.minimum; });
        var entry = fillLayerTimeslip(layerIndex, detailedLayerIndex, timeTicks, !l.labeled ? function () { return ''; } : layerIndex === timeAxisLayerCount - 1 ? l.detailedLabelFormat : l.minorTickLabelFormat, (0, exports.notTooDense)(domainFromS, domainToS, binWidth, cartesianWidth, exports.MAX_TIME_GRID_COUNT)(l)).entry;
        var minLabelGap = 4;
        var lastTick = entry.ticks[entry.ticks.length - 1];
        if (lastTick && lastTick.position + entry.labelBox.maxLabelBboxWidth > range[1]) {
            lastTick.label = '';
        }
        return __assign(__assign(__assign({}, combinedEntry), entry), { ticks: (combinedEntry.ticks || []).concat(entry.ticks.filter(function (tick, i, a) {
                return i > 0 ||
                    !a[1] ||
                    a[1].domainClampedPosition - tick.domainClampedPosition >= entry.labelBox.maxLabelBboxWidth + minLabelGap;
            })) });
    }, {
        ticks: [],
        labelBox: {
            maxLabelBboxWidth: 0,
            maxLabelBboxHeight: 0,
            maxLabelTextWidth: 0,
            maxLabelTextHeight: 0,
            isHidden: true,
        },
        scale: scale,
    });
}
exports.multilayerAxisEntry = multilayerAxisEntry;
//# sourceMappingURL=multilayer_ticks.js.map