"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LOCALE_TRANSLATIONS = void 0;
exports.LOCALE_TRANSLATIONS = {
    'ar-TN': {
        bar: 'حاجز',
        year: ['سنة', 'سنوات'],
        month: ['شهر', 'اشهر'],
        week: ['أسبوع', 'أسابيع'],
        day: ['يوم', 'أيام'],
        hour: ['ساعة', 'ساعات'],
        minute: ['دقيقة', 'دقائق'],
        second: ['ثانية', 'ثواني'],
        millisecond: ['مللي ثانية', 'مللي ثانية'],
        one: ['', ''],
    },
    'de-CH': {
        bar: 'Balken',
        year: ['Jahr', 'Jahre'],
        month: ['Monat', 'Monate'],
        week: ['Woche', 'Wochen'],
        day: ['Tag', 'Tage'],
        hour: ['Stunde', 'Stunden'],
        minute: ['Minute', 'Minuten'],
        second: ['Sekunde', 'Sekunden'],
        millisecond: ['Millisekunde', 'Millisekunden'],
        one: ['', ''],
    },
    'fr-FR': {
        bar: 'barre',
        year: ['année', 'ans'],
        month: ['mois', 'mois'],
        week: ['semaine', 'semaines'],
        day: ['jour', 'jours'],
        hour: ['heure', 'heures'],
        minute: ['minute', 'minutes'],
        second: ['seconde', 'secondes'],
        millisecond: ['milliseconde', 'millisecondes'],
        one: ['', ''],
    },
    'en-US': {
        bar: 'bar',
        year: ['year', 'years'],
        month: ['month', 'months'],
        week: ['week', 'weeks'],
        day: ['day', 'days'],
        hour: ['hour', 'hours'],
        minute: ['minute', 'minutes'],
        second: ['second', 'seconds'],
        millisecond: ['millisecond', 'milliseconds'],
        one: ['', ''],
    },
    'el-GR': {
        bar: 'γραμμή',
        year: ['χρόνος', 'μήνες'],
        month: ['μήνα', 'months'],
        week: ['εβδομάδα', 'εβδομάδες'],
        day: ['μέρα', 'ημέρες'],
        hour: ['ώρα', 'ώρες'],
        minute: ['λεπτό', 'λεπτά'],
        second: ['δευτερόλεπτο', 'δευτερόλεπτα'],
        millisecond: ['χιλιοστό του δευτερολέπτου', 'χιλιοστά του δευτερολέπτου'],
        one: ['', ''],
    },
    'hu-HU': {
        bar: 'oszlop',
        year: ['év', 'év'],
        month: ['hónap', 'hónap'],
        week: ['hét', 'hét'],
        day: ['nap', 'nap'],
        hour: ['óra', 'óra'],
        minute: ['perc', 'perc'],
        second: ['másodperc', 'másodperc'],
        millisecond: ['ezredmásodperc', 'ezredmásodperc'],
        one: ['', ''],
    },
    'he-IL': {
        bar: 'עַמוּדָה',
        year: ['שנה', 'years'],
        month: ['חודש', 'חודשים'],
        week: ['שבוע', 'שבועות'],
        day: ['יום', 'ימים'],
        hour: ['שעה', 'שעות'],
        minute: ['דקות', 'דקות'],
        second: ['השני', 'שניות'],
        millisecond: ['אלפית השנייה', 'אלפיות השנייה'],
        one: ['', ''],
    },
    'hi-IN': {
        bar: 'बार',
        year: ['वर्ष', 'साल'],
        month: ['महीना', 'महीने'],
        week: ['सप्ताह', 'सप्ताह'],
        day: ['दिन', 'दिन'],
        hour: ['घंटा', 'घंटे'],
        minute: ['मिनट', 'मिनट'],
        second: ['सेकंड', 'सेकंड'],
        millisecond: ['मिलीसेकंड', 'मिलीसेकेंड'],
        one: ['', ''],
    },
    'it-IT': {
        bar: 'barra',
        year: ['anno', 'anni'],
        month: ['mese', 'mesi'],
        week: ['settimana', 'settimane'],
        day: ['giorno', 'giorni'],
        hour: ['ora', 'ore'],
        minute: ['minuto', 'minuti'],
        second: ['secondo', 'secondi'],
        millisecond: ['millisecondo', 'millisecondi'],
        one: ['', ''],
    },
    'ja-JA': {
        bar: '棒',
        year: ['年', '年間'],
        month: ['ヶ月', 'ヵ月'],
        week: ['週間', '週間'],
        day: ['日', '日間'],
        hour: ['時間', '時間'],
        minute: ['分', '分間'],
        second: ['秒', '秒間'],
        millisecond: ['ミリ秒', 'ミリ秒'],
        one: ['', ''],
    },
    'ru-RU': {
        bar: 'полоса',
        year: ['год', 'лет'],
        month: ['месяц', 'месяцев'],
        week: ['неделя', 'недель'],
        day: ['день', 'дней'],
        hour: ['час', 'часов'],
        minute: ['минута', 'минут'],
        second: ['секунда', 'секунд'],
        millisecond: ['миллисекунда', 'миллисекунд'],
        one: ['', ''],
    },
};
//# sourceMappingURL=locale_translations.js.map