"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.zeroTouch = exports.twoTouchPinch = exports.getPinchRatio = exports.eraseMultitouch = exports.setNewMultitouch = exports.continuedTwoPointTouch = exports.touches = exports.touchMidpoint = exports.initialMultitouch = void 0;
var initialMultitouch = function () { return []; };
exports.initialMultitouch = initialMultitouch;
var touchMidpoint = function (multitouch) {
    return multitouch.reduce(function (sum, _a) {
        var position = _a.position;
        return sum + position;
    }, 0) / multitouch.length;
};
exports.touchMidpoint = touchMidpoint;
var isNonNull = function (thing) { return thing !== null; };
var touches = function (e) {
    var _a, _b;
    return __spreadArray([], __read(new Array((_b = (_a = e.touches) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0)), false).map(function (_, i) { return e.touches.item(i); })
        .filter(isNonNull)
        .map(function (t) { return ({ id: t.identifier, position: t.clientX }); })
        .sort(function (_a, _b) {
        var a = _a.position;
        var b = _b.position;
        return a - b;
    });
};
exports.touches = touches;
var continuedTwoPointTouch = function (multitouch, newMultitouch) {
    return __spreadArray(__spreadArray([], __read(newMultitouch), false), __read(multitouch), false).filter(function (t, i, a) { return a.findIndex(function (tt) { return tt.id === t.id; }) === i; }).length === 2;
};
exports.continuedTwoPointTouch = continuedTwoPointTouch;
var setNewMultitouch = function (multitouch, newMultitouch) {
    return multitouch.splice.apply(multitouch, __spreadArray([0, Infinity], __read(newMultitouch), false));
};
exports.setNewMultitouch = setNewMultitouch;
var eraseMultitouch = function (multitouch) { return multitouch.splice(0, Infinity); };
exports.eraseMultitouch = eraseMultitouch;
var getPinchRatio = function (multitouch, newMultitouch) {
    return (multitouch[1].position - multitouch[0].position) / (newMultitouch[1].position - newMultitouch[0].position);
};
exports.getPinchRatio = getPinchRatio;
var twoTouchPinch = function (multitouch) { return multitouch.length === 2; };
exports.twoTouchPinch = twoTouchPinch;
var zeroTouch = function (multitouch) { return multitouch.length === 0; };
exports.zeroTouch = zeroTouch;
//# sourceMappingURL=multitouch.js.map