"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.elementSize = exports.zoomSafePointerY = exports.zoomSafePointerX = void 0;
var zoomSafePointerX = function (e) { return e.offsetX; };
exports.zoomSafePointerX = zoomSafePointerX;
var zoomSafePointerY = function (e) { return e.offsetY; };
exports.zoomSafePointerY = zoomSafePointerY;
var elementSize = function (canvas, horizontal, pad) {
    var outerSize = Number.parseFloat(horizontal ? canvas.style.width : canvas.style.height);
    var innerLeading = outerSize * pad[0];
    var innerSize = outerSize * (1 - pad.reduce(function (p, n) { return p + n; }));
    var innerTrailing = innerLeading + innerSize;
    return {
        outerSize: outerSize,
        innerLeading: innerLeading,
        innerTrailing: innerTrailing,
        innerSize: innerSize,
    };
};
exports.elementSize = elementSize;
//# sourceMappingURL=dom.js.map