"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.withDeltaTime = exports.withAnimation = void 0;
var withAnimation = function (renderer) {
    var rAF = -1;
    return function () {
        window.cancelAnimationFrame(rAF);
        rAF = window.requestAnimationFrame(renderer);
    };
};
exports.withAnimation = withAnimation;
var withDeltaTime = function (renderer) {
    var prevT = 0;
    return function (t) {
        var deltaT = t - prevT;
        prevT = t;
        renderer(deltaT);
    };
};
exports.withDeltaTime = withDeltaTime;
//# sourceMappingURL=animation.js.map