"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.timeslipRender = void 0;
var config_1 = require("./config");
var data_1 = require("./data");
var data_fetch_1 = require("./data_fetch");
var chart_title_1 = require("./render/annotations/chart_title");
var time_extent_1 = require("./render/annotations/time_extent");
var time_unit_1 = require("./render/annotations/time_unit");
var cartesian_1 = require("./render/cartesian");
var debug_box_1 = require("./render/glyphs/debug_box");
var continuous_time_rasters_1 = require("../../xy_chart/axes/timeslip/continuous_time_rasters");
var numerical_rasters_1 = require("../../xy_chart/axes/timeslip/numerical_rasters");
var axis_model_1 = require("../projections/axis_model");
var domain_tween_1 = require("../projections/domain_tween");
var scale_1 = require("../projections/scale");
var zoom_pan_1 = require("../projections/zoom_pan");
var animation_1 = require("../utils/animation");
var dom_1 = require("../utils/dom");
var multitouch_1 = require("../utils/multitouch");
var HEADER_ROW_Y_OFFSET = 3;
var getNullDimensions = function () { return ({
    outerSize: NaN,
    innerLeading: NaN,
    innerTrailing: NaN,
    innerSize: NaN,
}); };
var getNullInteractionState = function () { return ({
    horizontalZoomPan: (0, zoom_pan_1.initialZoomPan)(),
    multitouch: (0, multitouch_1.initialMultitouch)(),
    niceDomainMin: NaN,
    niceDomainMax: NaN,
    horizontalScreenDimensions: getNullDimensions(),
    verticalScreenDimensions: getNullDimensions(),
}); };
var rasterSelector = config_1.HORIZONTAL_AXIS === 'continuousTime' ? (0, continuous_time_rasters_1.continuousTimeRasters)(config_1.rasterConfig, config_1.timeZone) : (0, numerical_rasters_1.numericalRasters)(config_1.rasterConfig);
var yTickNumberFormatter = new Intl.NumberFormat(config_1.config.locale, config_1.config.numUnit === 'none'
    ? {}
    : {
        notation: 'compact',
        compactDisplay: config_1.config.numUnit,
    });
var yTickNumberFormat = function (value) { return yTickNumberFormatter.format(value); };
var touchUpdate = function (interactionState, newMultitouch) {
    var multitouch = interactionState.multitouch, zoomPan = interactionState.horizontalZoomPan, horizontalScreenDimensions = interactionState.horizontalScreenDimensions;
    var noPreviousTouch = (0, multitouch_1.zeroTouch)(multitouch);
    var isTwoTouchPinch = (0, multitouch_1.twoTouchPinch)(newMultitouch);
    var center = (0, multitouch_1.touchMidpoint)(newMultitouch);
    var isPinchStart = noPreviousTouch && isTwoTouchPinch;
    if (isPinchStart) {
        (0, multitouch_1.setNewMultitouch)(multitouch, newMultitouch);
        (0, zoom_pan_1.startTouchZoom)(zoomPan);
        (0, zoom_pan_1.markDragStartPosition)(zoomPan, center);
    }
    else if (!isTwoTouchPinch || !(0, multitouch_1.continuedTwoPointTouch)(multitouch, newMultitouch)) {
        (0, multitouch_1.eraseMultitouch)(multitouch);
        (0, zoom_pan_1.resetTouchZoom)(zoomPan);
    }
    var isPinchZoom = (0, multitouch_1.twoTouchPinch)(multitouch);
    var isTouchOngoing = (0, zoom_pan_1.touchOngoing)(zoomPan);
    var isPanOngoing = (0, zoom_pan_1.panOngoing)(zoomPan);
    if (isPinchZoom) {
        var pinchRatio = (0, multitouch_1.getPinchRatio)(multitouch, newMultitouch);
        var desiredZoomChange = (0, zoom_pan_1.multiplierToZoom)(pinchRatio);
        (0, zoom_pan_1.doZoomAroundPosition)(zoomPan, horizontalScreenDimensions, center, desiredZoomChange, 0, true);
    }
    else {
        var inCartesianBand_1 = true;
        if (inCartesianBand_1 || isTouchOngoing) {
            if (isPanOngoing) {
                (0, zoom_pan_1.doPanFromPosition)(zoomPan, horizontalScreenDimensions.innerSize, center);
            }
            else {
                (0, zoom_pan_1.markDragStartPosition)(zoomPan, center);
            }
        }
    }
    return isPinchZoom || (isTouchOngoing && isPanOngoing);
};
var inCartesianBand = function (size, value) { return size.innerLeading <= value && value <= size.innerTrailing; };
var ensureCanvasResolution = function (canvas, outerWidth, outerHeight, newCanvasWidth, newCanvasHeight) {
    if (newCanvasWidth !== outerWidth) {
        canvas.setAttribute('width', String(newCanvasWidth));
    }
    if (newCanvasHeight !== outerHeight) {
        canvas.setAttribute('height', String(newCanvasHeight));
    }
};
var doCartesian = function (ctx, cartesianHeight, interactionState, deltaT, cartesianWidth, timeDomain, dataState, emWidth) {
    ctx.save();
    ctx.translate(0, cartesianHeight);
    var domainLandmarks = __spreadArray([
        dataState.dataResponse.stats.minValue,
        dataState.dataResponse.stats.maxValue
    ], __read((config_1.ZERO_Y_BASE ? [0] : [])), false);
    var desiredTickCount = (0, scale_1.getDesiredTickCount)(cartesianHeight, config_1.config.smallFontSize, config_1.config.sparse);
    var _a = (0, axis_model_1.axisModel)(domainLandmarks, desiredTickCount), niceDomainMin = _a.niceDomainMin, niceDomainMax = _a.niceDomainMax, niceTicks = _a.niceTicks;
    var yTweenOngoing = (0, domain_tween_1.domainTween)(interactionState, deltaT, niceDomainMin, niceDomainMax);
    var yUnitScale = (0, scale_1.makeLinearScale)(interactionState.niceDomainMin, interactionState.niceDomainMax, 0, 1);
    var dataDemand = (0, cartesian_1.renderCartesian)(ctx, config_1.config, dataState, config_1.defaultMinorTickLabelFormat, emWidth, config_1.fadeOutPixelWidth, config_1.defaultLabelFormat, yTickNumberFormat, rasterSelector, cartesianWidth, cartesianHeight, timeDomain, yUnitScale, niceTicks);
    ctx.restore();
    return { yTweenOngoing: yTweenOngoing, dataDemand: dataDemand };
};
var renderChartWithTime = function (ctx, backgroundFillStyle, newCanvasWidth, newCanvasHeight, config, chartWidth, cartesianTop, cartesianLeft, cartesianHeight, interactionState, deltaT, cartesianWidth, drawCartesianBox, chartTopFontSize, dataState, emWidth, dpi, fromSec, toSec) {
    ctx.save();
    ctx.scale(dpi, dpi);
    ctx.fillStyle = backgroundFillStyle;
    ctx.fillRect(0, 0, newCanvasWidth, newCanvasHeight);
    (0, chart_title_1.renderChartTitle)(ctx, config.subduedFontColor, chartWidth);
    ctx.translate(cartesianLeft, cartesianTop);
    var timeDomain = (0, zoom_pan_1.getFocusDomain)(interactionState.horizontalZoomPan, fromSec, toSec);
    var _a = doCartesian(ctx, cartesianHeight, interactionState, deltaT, cartesianWidth, timeDomain, dataState, emWidth), yTweenOngoing = _a.yTweenOngoing, dataDemand = _a.dataDemand;
    if (drawCartesianBox) {
        (0, debug_box_1.renderDebugBox)(ctx, cartesianWidth, cartesianHeight);
    }
    var headerRowOffsetY = -chartTopFontSize * HEADER_ROW_Y_OFFSET;
    (0, time_unit_1.renderTimeUnitAnnotation)(ctx, config, dataDemand.binUnitCount, dataDemand.binUnit, chartTopFontSize, headerRowOffsetY, dataDemand.unitBarMaxWidthPixels);
    (0, time_extent_1.renderTimeExtentAnnotation)(ctx, config, config_1.localeOptions, timeDomain, cartesianWidth, headerRowOffsetY);
    ctx.restore();
    return { yTweenOngoing: yTweenOngoing, dataDemand: dataDemand };
};
var chartWithTime = function (canvas, ctx, config, interactionState, dataState, deltaT, dpi, emWidth) {
    var newHorizontalScreenDimensions = (0, dom_1.elementSize)(canvas, true, config_1.horizontalCartesianAreaPad);
    var chartWidth = newHorizontalScreenDimensions.outerSize;
    var cartesianLeft = newHorizontalScreenDimensions.innerLeading;
    var cartesianWidth = newHorizontalScreenDimensions.innerSize;
    var newVerticalScreenDimensions = (0, dom_1.elementSize)(canvas, false, config_1.verticalCartesianAreaPad);
    var chartHeight = newVerticalScreenDimensions.outerSize;
    var cartesianTop = newVerticalScreenDimensions.innerLeading;
    var cartesianHeight = newVerticalScreenDimensions.innerSize;
    var newCanvasWidth = dpi * chartWidth;
    var newCanvasHeight = dpi * chartHeight;
    ensureCanvasResolution(canvas, interactionState.horizontalScreenDimensions.outerSize, interactionState.verticalScreenDimensions.outerSize, newCanvasWidth, newCanvasHeight);
    interactionState.horizontalScreenDimensions = newHorizontalScreenDimensions;
    interactionState.verticalScreenDimensions = newVerticalScreenDimensions;
    var _a = renderChartWithTime(ctx, config_1.backgroundFillStyle, newCanvasWidth, newCanvasHeight, config, chartWidth, cartesianTop, cartesianLeft, cartesianHeight, interactionState, deltaT, cartesianWidth, config_1.drawCartesianBox, config_1.chartTopFontSize, dataState, emWidth, dpi, config.domainFrom, config.domainTo), yTweenOngoing = _a.yTweenOngoing, dataDemand = _a.dataDemand;
    var dataArrived = !dataState.pending &&
        (0, data_fetch_1.invalid)(dataState, dataDemand) &&
        dataDemand.lo &&
        dataDemand.hi &&
        dataDemand.binUnit &&
        dataDemand.binUnitCount;
    if (dataArrived) {
        dataState.pending = true;
    }
    return { dataArrived: dataArrived, yTweenOngoing: yTweenOngoing, dataDemand: dataDemand };
};
var setupEventHandlers = function (canvas, interactionState, timedRender, scheduleChartRender) {
    var wheel = function (e) {
        var isPanning = e.metaKey;
        var wheeledDistanceRatio = e.deltaY / interactionState.horizontalScreenDimensions.innerSize;
        if (!inCartesianBand(interactionState.verticalScreenDimensions, (0, dom_1.zoomSafePointerY)(e)))
            return;
        if (isPanning) {
            var innerSizeRelativeDelta = wheeledDistanceRatio * config_1.wheelPanVelocity;
            (0, zoom_pan_1.doPanFromJumpDelta)(interactionState.horizontalZoomPan, -innerSizeRelativeDelta);
        }
        else {
            var desiredZoomChange = -wheeledDistanceRatio * config_1.wheelZoomVelocity;
            (0, zoom_pan_1.doZoomAroundPosition)(interactionState.horizontalZoomPan, interactionState.horizontalScreenDimensions, (0, dom_1.zoomSafePointerX)(e), desiredZoomChange, 0, false);
        }
        scheduleChartRender();
    };
    var dragStart = function (e) { return (0, zoom_pan_1.markDragStartPosition)(interactionState.horizontalZoomPan, (0, dom_1.zoomSafePointerX)(e)); };
    var kineticDragFlywheel = function (t) {
        var needsRerender = (0, zoom_pan_1.kineticFlywheel)(interactionState.horizontalZoomPan, interactionState.horizontalScreenDimensions.innerSize);
        if (needsRerender) {
            timedRender(t);
            window.requestAnimationFrame(kineticDragFlywheel);
        }
    };
    var dragEnd = function () {
        (0, zoom_pan_1.endDrag)(interactionState.horizontalZoomPan);
        window.requestAnimationFrame(kineticDragFlywheel);
    };
    var touchmove = function (e) {
        var shouldUpdate = touchUpdate(interactionState, (0, multitouch_1.touches)(e));
        if (shouldUpdate)
            scheduleChartRender();
    };
    var mousemove = function (e) {
        if (e.buttons !== 1)
            return;
        interactionState.multitouch = (0, multitouch_1.initialMultitouch)();
        var zoomPan = interactionState.horizontalZoomPan;
        (0, zoom_pan_1.resetTouchZoom)(zoomPan);
        if ((inCartesianBand(interactionState.horizontalScreenDimensions, (0, dom_1.zoomSafePointerX)(e)) &&
            inCartesianBand(interactionState.verticalScreenDimensions, (0, dom_1.zoomSafePointerY)(e))) ||
            (0, zoom_pan_1.touchOngoing)(zoomPan)) {
            if ((0, zoom_pan_1.panOngoing)(zoomPan)) {
                (0, zoom_pan_1.doPanFromPosition)(zoomPan, interactionState.horizontalScreenDimensions.innerSize, (0, dom_1.zoomSafePointerX)(e));
                scheduleChartRender();
            }
            else {
                dragStart(e);
            }
        }
    };
    var mousedown = function (e) {
        return inCartesianBand(interactionState.horizontalScreenDimensions, (0, dom_1.zoomSafePointerX)(e)) &&
            inCartesianBand(interactionState.verticalScreenDimensions, (0, dom_1.zoomSafePointerY)(e)) &&
            dragStart(e);
    };
    var keydown = function (e) {
        var _a, _b;
        var panDirection = (_a = { ArrowLeft: -1, ArrowRight: 1 }[e.code]) !== null && _a !== void 0 ? _a : 0;
        var zoomDirection = (_b = { ArrowUp: -1, ArrowDown: 1 }[e.code]) !== null && _b !== void 0 ? _b : 0;
        if (panDirection || zoomDirection) {
            if (panDirection) {
                var normalizedDeltaPan = panDirection / config_1.keyPanVelocityDivisor;
                (0, zoom_pan_1.doPanFromJumpDelta)(interactionState.horizontalZoomPan, normalizedDeltaPan);
            }
            if (zoomDirection) {
                var normalizedDeltaZoom = zoomDirection / config_1.keyZoomVelocityDivisor;
                var center = 0.5;
                (0, zoom_pan_1.doZoomFromJumpDelta)(interactionState.horizontalZoomPan, normalizedDeltaZoom, center);
            }
            e.preventDefault();
            scheduleChartRender();
        }
    };
    window.addEventListener('resize', scheduleChartRender, { passive: false });
    canvas.addEventListener('wheel', wheel, { passive: false });
    canvas.addEventListener('mousemove', mousemove, { passive: false });
    canvas.addEventListener('mousedown', mousedown, { passive: false });
    canvas.addEventListener('mouseup', dragEnd, { passive: false });
    canvas.addEventListener('touchmove', touchmove, { passive: false });
    canvas.addEventListener('touchend', dragEnd, { passive: false });
    canvas.addEventListener('touchcancel', dragEnd, { passive: false });
    canvas.addEventListener('keydown', keydown, { passive: false });
};
var timeslipRender = function (canvas, ctx, getData) {
    var dpi = window.devicePixelRatio;
    var emWidth = ctx.measureText('mmmmmmmmmm').width / 10;
    var interactionState = getNullInteractionState();
    var dataState = (0, data_fetch_1.getNullDataState)();
    var chartWithUpdate = function (t) {
        var _a = chartWithTime(canvas, ctx, config_1.config, interactionState, dataState, t, dpi, emWidth), dataArrived = _a.dataArrived, yTweenOngoing = _a.yTweenOngoing, dataDemand = _a.dataDemand;
        if (dataArrived)
            (0, data_fetch_1.updateDataState)(dataState, dataDemand, (0, data_1.getEnrichedData)(getData(dataDemand)));
        if (dataArrived || yTweenOngoing)
            scheduleChartRender();
    };
    var timedRender = (0, animation_1.withDeltaTime)(chartWithUpdate);
    var scheduleChartRender = (0, animation_1.withAnimation)(timedRender);
    scheduleChartRender();
    setupEventHandlers(canvas, interactionState, timedRender, scheduleChartRender);
};
exports.timeslipRender = timeslipRender;
//# sourceMappingURL=timeslip_render.js.map