"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderRaster = exports.calcColumnBar = void 0;
var column_1 = require("./column");
var iterables_1 = require("../../../../common/iterables");
var multilayer_ticks_1 = require("../../../xy_chart/axes/timeslip/multilayer_ticks");
var math_1 = require("../../utils/math");
var TIMESLIP_MAX_TIME_GRID_COUNT = 100 || multilayer_ticks_1.MAX_TIME_GRID_COUNT;
var renderHorizontalGridLines = function (ctx, config, niceTicks, yUnitScale, cartesianHeight, yTickNumberFormatter, cartesianWidth) {
    var e_1, _a;
    ctx.save();
    var _b = config.backgroundColor, r = _b.r, g = _b.g, b = _b.b;
    var lineStyle = config.implicit
        ? "rgb(".concat(r, ",").concat(g, ",").concat(b, ")")
        : "rgba(128,128,128,".concat(config.a11y.contrast === 'low' ? 0.5 : 1, ")");
    ctx.textBaseline = 'middle';
    ctx.font = config.cssFontShorthand;
    try {
        for (var niceTicks_1 = __values(niceTicks), niceTicks_1_1 = niceTicks_1.next(); !niceTicks_1_1.done; niceTicks_1_1 = niceTicks_1.next()) {
            var gridDomainValueY = niceTicks_1_1.value;
            var yUnit = yUnitScale(gridDomainValueY);
            if (yUnit !== (0, math_1.clamp)(yUnit, -0.01, 1.01)) {
                continue;
            }
            var y = -cartesianHeight * yUnit;
            var text = yTickNumberFormatter(gridDomainValueY);
            ctx.fillStyle = gridDomainValueY === 0 ? config.defaultFontColor : lineStyle;
            ctx.fillRect(-config.yTickOverhang, y, cartesianWidth + 2 * config.yTickOverhang, gridDomainValueY === 0 ? 0.5 : config.implicit ? 0.2 : 0.1);
            ctx.fillStyle = config.subduedFontColor;
            ctx.textAlign = 'left';
            ctx.fillText(text, cartesianWidth + config.yTickOverhang + config.yTickGap, y);
            ctx.textAlign = 'right';
            ctx.fillText(text, -config.yTickOverhang - config.yTickGap, y);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (niceTicks_1_1 && !niceTicks_1_1.done && (_a = niceTicks_1.return)) _a.call(niceTicks_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    ctx.restore();
};
var binsToRender = function (binStarts, domainFrom, domainTo) {
    var e_2, _a;
    var binStartList = [];
    try {
        for (var binStarts_1 = __values(binStarts), binStarts_1_1 = binStarts_1.next(); !binStarts_1_1.done; binStarts_1_1 = binStarts_1.next()) {
            var binStart = binStarts_1_1.value;
            if (binStart.minimum > domainTo)
                break;
            if (binStart.minimum < domainFrom) {
                binStartList[0] = binStart;
            }
            else {
                binStartList.push(binStart);
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (binStarts_1_1 && !binStarts_1_1.done && (_a = binStarts_1.return)) _a.call(binStarts_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return binStartList;
};
var calcColumnBar = function (getPixelX, unitBarMaxWidthPixelsSum, unitBarMaxWidthPixelsCount, i, halfLineThickness, implicit, _a) {
    var minimum = _a.minimum, supremum = _a.supremum;
    if (i !== 0)
        return { unitBarMaxWidthPixelsSum: unitBarMaxWidthPixelsSum, unitBarMaxWidthPixelsCount: unitBarMaxWidthPixelsCount };
    var barPad = implicit ? halfLineThickness : 0;
    var fullBarPixelX = getPixelX(minimum);
    var barMaxWidthPixels = getPixelX(supremum) - fullBarPixelX - 2 * barPad;
    return {
        unitBarMaxWidthPixelsSum: unitBarMaxWidthPixelsSum + barMaxWidthPixels,
        unitBarMaxWidthPixelsCount: unitBarMaxWidthPixelsCount + 1,
    };
};
exports.calcColumnBar = calcColumnBar;
var updateLoHi = function (binStarts, implicit, halfLineThickness, getPixelX, loHi, i) {
    var e_3, _a;
    try {
        for (var binStarts_2 = __values(binStarts), binStarts_2_1 = binStarts_2.next(); !binStarts_2_1.done; binStarts_2_1 = binStarts_2.next()) {
            var binStart = binStarts_2_1.value;
            if (i === 0) {
                loHi.lo = loHi.lo || binStart;
                loHi.hi = binStart;
            }
            var _b = (0, exports.calcColumnBar)(getPixelX, loHi.unitBarMaxWidthPixelsSum, loHi.unitBarMaxWidthPixelsCount, i, halfLineThickness, implicit, binStart), unitBarMaxWidthPixelsSum = _b.unitBarMaxWidthPixelsSum, unitBarMaxWidthPixelsCount = _b.unitBarMaxWidthPixelsCount;
            loHi.unitBarMaxWidthPixelsSum = unitBarMaxWidthPixelsSum;
            loHi.unitBarMaxWidthPixelsCount = unitBarMaxWidthPixelsCount;
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (binStarts_2_1 && !binStarts_2_1.done && (_a = binStarts_2.return)) _a.call(binStarts_2);
        }
        finally { if (e_3) throw e_3.error; }
    }
};
var renderRaster = function (ctx, config, dataState, fadeOutPixelWidth, emWidth, defaultMinorTickLabelFormat, defaultLabelFormat, yTickNumberFormatter, domainFrom, domainTo, getPixelX, cartesianWidth, cartesianHeight, niceTicks, yUnitScale, layers) {
    return function (loHi, _a, i, a) {
        var _b;
        var labeled = _a.labeled, intervals = _a.intervals, minorTickLabelFormat = _a.minorTickLabelFormat, detailedLabelFormat = _a.detailedLabelFormat, minimumTickPixelDistance = _a.minimumTickPixelDistance, unit = _a.unit, unitMultiplier = _a.unitMultiplier;
        var valid = dataState.valid, rows = dataState.dataResponse.rows;
        var minorLabelFormat = minorTickLabelFormat !== null && minorTickLabelFormat !== void 0 ? minorTickLabelFormat : defaultMinorTickLabelFormat;
        var labelFormat = (_b = detailedLabelFormat !== null && detailedLabelFormat !== void 0 ? detailedLabelFormat : minorLabelFormat) !== null && _b !== void 0 ? _b : defaultLabelFormat;
        var textNestLevel = a.slice(0, i + 1).filter(function (layer) { return layer.labeled; }).length;
        var lineNestLevel = a[i] === a[0] ? 0 : textNestLevel;
        var textNestLevelRowLimited = Math.min(config.maxLabelRowCount, textNestLevel);
        var lineNestLevelRowLimited = Math.min(config.maxLabelRowCount, lineNestLevel);
        var lineThickness = config.lineThicknessSteps[i];
        var luma = config.lumaSteps[i] *
            (config.darkMode ? (config.a11y.contrast === 'low' ? 0.5 : 1) : config.a11y.contrast === 'low' ? 1.5 : 1);
        var halfLineThickness = lineThickness / 2;
        var notTooDenseGridLayer = (0, multilayer_ticks_1.notTooDense)(domainFrom, domainTo, 0, cartesianWidth, TIMESLIP_MAX_TIME_GRID_COUNT);
        var binStartList = binsToRender(intervals(domainFrom, domainTo), domainFrom, domainTo);
        updateLoHi(binStartList, config.implicit, halfLineThickness, getPixelX, loHi, i);
        var finestRaster = i === 0;
        var renderBar = finestRaster &&
            valid &&
            dataState.binUnit === layers[0].unit &&
            dataState.binUnitCount === layers[0].unitMultiplier;
        if (labeled && textNestLevel <= config.maxLabelRowCount)
            (0, column_1.renderColumnTickLabels)(ctx, config, fadeOutPixelWidth, emWidth, getPixelX, labelFormat, minorLabelFormat, textNestLevelRowLimited, cartesianWidth, binStartList);
        if (renderBar)
            (0, column_1.renderColumnBars)(ctx, getPixelX, cartesianWidth, cartesianHeight, config.implicit ? halfLineThickness : 0, rows, yUnitScale, config.barChroma, config.barFillAlpha, binStartList);
        if (notTooDenseGridLayer({ minimumTickPixelDistance: minimumTickPixelDistance, unit: unit, unitMultiplier: unitMultiplier })) {
            var rowPixelPitch_1 = config.rowPixelPitch;
            ctx.fillStyle = "rgb(".concat(luma, ",").concat(luma, ",").concat(luma, ")");
            var lastBinForClosingGridline = binStartList.slice(-1).map(function (bin) { return (__assign(__assign({}, bin), { binStart: bin.supremum })); });
            (0, iterables_1.pipeline)(__spreadArray(__spreadArray([], __read(binStartList), false), __read(lastBinForClosingGridline), false), (0, iterables_1.mapping)(function (_a) {
                var minimum = _a.minimum;
                return minimum;
            }), (0, iterables_1.filtering)(function (binStart) { return binStart >= domainFrom; }), (0, iterables_1.mapping)(getPixelX), (0, iterables_1.doing)(function (pixelX) {
                var left = pixelX - 0.5 * lineThickness;
                var height = cartesianHeight + lineNestLevelRowLimited * rowPixelPitch_1;
                ctx.fillRect(left, -cartesianHeight, lineThickness, height);
            }), iterables_1.executing);
        }
        if (binStartList.length > 0 && binStartList[0].minimum < domainFrom) {
            var precedingBinStart = binStartList[0];
            if (finestRaster) {
                loHi.lo = precedingBinStart;
            }
            var _c = (0, exports.calcColumnBar)(getPixelX, loHi.unitBarMaxWidthPixelsSum, loHi.unitBarMaxWidthPixelsCount, i, halfLineThickness, config.implicit, precedingBinStart), unitBarMaxWidthPixelsSum = _c.unitBarMaxWidthPixelsSum, unitBarMaxWidthPixelsCount = _c.unitBarMaxWidthPixelsCount;
            loHi.unitBarMaxWidthPixelsSum = unitBarMaxWidthPixelsSum;
            loHi.unitBarMaxWidthPixelsCount = unitBarMaxWidthPixelsCount;
        }
        renderHorizontalGridLines(ctx, config, niceTicks, yUnitScale, cartesianHeight, yTickNumberFormatter, cartesianWidth);
        return loHi;
    };
};
exports.renderRaster = renderRaster;
//# sourceMappingURL=raster.js.map