"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderBarGlyph = void 0;
function renderBarGlyph(ctx, barWidthPixels, leftShortfall, maxBarHeight, yUnitScale, foundRow, r, g, b, opacity, barX, opacityDependentLineThickness) {
    var renderedBarWidth = Math.max(0, barWidthPixels - leftShortfall);
    var barEnd = -maxBarHeight * yUnitScale(foundRow.value);
    var barStart = -maxBarHeight * yUnitScale(0);
    var barHeight = Math.abs(barStart - barEnd);
    var barY = Math.min(barStart, barEnd);
    ctx.fillStyle = "rgba(".concat(r, ",").concat(g, ",").concat(b, ",").concat(opacity, ")");
    ctx.fillRect(barX, barY, renderedBarWidth, barHeight);
    if (barEnd === barEnd) {
        ctx.fillStyle = "rgba(".concat(r, ",").concat(g, ",").concat(b, ",1)");
        ctx.fillRect(barX, barEnd, renderedBarWidth, opacityDependentLineThickness);
    }
}
exports.renderBarGlyph = renderBarGlyph;
//# sourceMappingURL=bar.js.map